/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.StatePageRow;
import org.drools.repository.AssetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatePageRowBuilder {
    public List<StatePageRow> createRows(PageRequest pageRequest, Iterator<AssetItem> it) {
        ArrayList<StatePageRow> rowList = new ArrayList<StatePageRow>();
        while (it.hasNext()) {
            AssetItem assetItem = it.next();
            rowList.add(this.makeStatePageRow(assetItem));
        }
        return rowList;
    }

    private StatePageRow makeStatePageRow(AssetItem assetItem) {
        StatePageRow row = new StatePageRow();
        row.setUuid(assetItem.getUUID());
        row.setFormat(assetItem.getFormat());
        row.setName(assetItem.getName());
        row.setDescription(assetItem.getDescription());
        row.setAbbreviatedDescription(StringUtils.abbreviate((String)assetItem.getDescription(), (int)80));
        row.setLastModified(assetItem.getLastModified().getTime());
        row.setStateName(assetItem.getState().getName());
        row.setPackageName(assetItem.getPackageName());
        return row;
    }
}

