/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.selector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.guvnor.server.selector.RuleBasedSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorManager {
    private static final Logger log = LoggerFactory.getLogger(SelectorManager.class);
    public static final String SELECTOR_CONFIG_PROPERTIES = "/selectors.properties";
    private static final SelectorManager INSTANCE = new SelectorManager("/selectors.properties");
    public final Map<String, AssetSelector> selectors = new HashMap();

    SelectorManager(String configPath) {
        log.debug("Loading selectors");
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream(configPath));
            props.put("BuiltInSelector", "org.drools.guvnor.server.selector.BuiltInSelector");
            for (String string : props.keySet()) {
                String val = props.getProperty(string);
                try {
                    if (val.endsWith("drl")) {
                        this.selectors.put(string, this.loadRuleSelector(val));
                        continue;
                    }
                    this.selectors.put(string, this.loadSelectorImplementation(val));
                }
                catch (Exception e) {
                    log.error("Unable to load a selector [" + val + "]", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error("Unable to load selectors.", (Throwable)e);
        }
    }

    public AssetSelector getSelector(String name) {
        if (name == null || "".equals(name.trim())) {
            return this.nilSelector();
        }
        if (this.selectors.containsKey(name)) {
            return (AssetSelector)this.selectors.get(name);
        }
        log.debug("No selector found by the name of " + name);
        return null;
    }

    public String[] getCustomSelectors() {
        Set s = this.selectors.keySet();
        ArrayList selectorList = new ArrayList();
        selectorList.addAll(s);
        selectorList.remove("BuiltInSelector");
        String[] result = new String[selectorList.size()];
        return selectorList.toArray(result);
    }

    private AssetSelector nilSelector() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private AssetSelector loadSelectorImplementation(String val) throws Exception {
        return (AssetSelector)Thread.currentThread().getContextClassLoader().loadClass(val).newInstance();
    }

    private AssetSelector loadRuleSelector(String val) {
        return new RuleBasedSelector(val);
    }

    public static SelectorManager getInstance() {
        return INSTANCE;
    }
}

