/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.dt.TemplateModel;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.template.DataProvider;
import org.drools.template.DataProviderCompiler;
import org.drools.template.objects.ArrayDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BRDRTPersistence
extends BRDRLPersistence {
    private static final Logger log = LoggerFactory.getLogger(BRDRTPersistence.class);
    private static final BRLPersistence INSTANCE = new BRDRTPersistence();
    private static final String PACKAGE_DECLARATION = "\npackage __template_dummy_package__\n";

    private BRDRTPersistence() {
    }

    public static BRLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(RuleModel model) {
        String ruleTemplate = super.marshalRule(model);
        log.debug("ruleTemplate:\n{}", (Object)ruleTemplate);
        DataProvider dataProvider = this.chooseDataProvider(model);
        DataProviderCompiler tplCompiler = new DataProviderCompiler();
        String generatedDRl = tplCompiler.compile(dataProvider, (InputStream)new ByteArrayInputStream(ruleTemplate.getBytes())).substring(PACKAGE_DECLARATION.length()).trim();
        log.debug("generated drl:\n{}", (Object)generatedDRl);
        return generatedDRl;
    }

    private DataProvider chooseDataProvider(RuleModel model) {
        TemplateModel tplModel = (TemplateModel)model;
        ArrayDataProvider dataProvider = tplModel.getRowsCount() > 0 ? new ArrayDataProvider(tplModel.getTableAsArray()) : new ArrayDataProvider(this.generateEmptyIterator(tplModel));
        return dataProvider;
    }

    private String[][] generateEmptyIterator(TemplateModel templateModel) {
        String[][] rows = new String[1][];
        TemplateModel.InterpolationVariable[] interpolationVariables = templateModel.getInterpolationVariablesList();
        if (interpolationVariables == null || interpolationVariables.length == 0) {
            rows[0] = new String[]{""};
        } else {
            rows[0] = new String[interpolationVariables.length];
            for (int i = 0; i < interpolationVariables.length; ++i) {
                rows[0][i] = interpolationVariables[i].getVarName() + "_na";
            }
        }
        return rows;
    }

    protected void marshalHeader(RuleModel model, StringBuilder buf) {
        TemplateModel templateModel = (TemplateModel)model;
        buf.append("template header\n");
        TemplateModel.InterpolationVariable[] interpolationVariables = templateModel.getInterpolationVariablesList();
        if (interpolationVariables.length == 0) {
            buf.append("test_var").append('\n');
        } else {
            for (TemplateModel.InterpolationVariable var : interpolationVariables) {
                buf.append(var.getVarName()).append('\n');
            }
        }
        buf.append(PACKAGE_DECLARATION).append("\ntemplate \"" + super.marshalRuleName((RuleModel)templateModel) + "\"\n\n");
        super.marshalHeader(model, buf);
    }

    protected String marshalRuleName(RuleModel model) {
        return super.marshalRuleName(model) + "_@{row.rowNumber}";
    }

    protected void marshalFooter(StringBuilder buf) {
        super.marshalFooter(buf);
        buf.append("\nend template");
    }
}

