/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.Date;
import org.drools.guvnor.client.rpc.LogEntry;

class MessageList {
    static int MAX = 500;
    LogEntry[] messages = new LogEntry[MAX];
    int current = 0;

    public synchronized void add(String message, int severity) {
        LogEntry entry = new LogEntry();
        entry.message = message;
        entry.timestamp = new Date();
        entry.severity = severity;
        if (this.current == MAX) {
            this.current = 0;
        }
        this.messages[this.current++] = entry;
    }

    public LogEntry[] getMessages() {
        LogEntry[] result = new LogEntry[this.current];
        System.arraycopy(this.messages, 0, result, 0, Math.min(this.messages.length, this.current));
        return result;
    }

    public synchronized void cleanEntry() {
        this.messages = new LogEntry[MAX];
        this.current = 0;
    }
}

