/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestEnvironmentSessionHelper {
    public static final Logger log = LoggerFactory.getLogger(TestEnvironmentSessionHelper.class);
    public static Repository repository;

    public static synchronized Session getSession() {
        return TestEnvironmentSessionHelper.getSession((boolean)true);
    }

    public static synchronized Session getSession(boolean erase) {
        if (repository == null) {
            try {
                if (erase) {
                    File repoDir = new File("repository");
                    log.info("DELETE test repo dir: " + repoDir.getAbsolutePath());
                    RepositorySessionUtil.deleteDir((File)repoDir);
                    log.info("TEST repo dir deleted.");
                }
                RulesRepositoryConfigurator config = RulesRepositoryConfigurator.getInstance(null);
                String home = System.getProperty("guvnor.repository.dir");
                Properties properties = new Properties();
                if (home != null) {
                    properties.setProperty("repository.root.directory", home);
                }
                repository = config.getJCRRepository();
                int retries = 3;
                Session testSession = null;
                while (retries > 0) {
                    try {
                        testSession = repository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
                        retries = 0;
                    }
                    catch (RepositoryException re) {
                        System.err.println("Failed to get the repository session: Retrying... ");
                        re.printStackTrace();
                        System.err.println("Attemptng to shutdown repository... ");
                        TestEnvironmentSessionHelper.shutdown();
                        repository = config.getJCRRepository();
                        --retries;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ie) {}
                    }
                }
                if (testSession == null) {
                    throw new IllegalStateException("Unable to get Repository Session. Refer to previous messages for details.");
                }
                RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(testSession);
                if (erase && admin.isRepositoryInitialized()) {
                    admin.clearRulesRepository();
                }
                config.setupRepository(testSession);
                File file = File.createTempFile("pete", "txt");
                file.deleteOnExit();
                PrintWriter out = new PrintWriter(new FileOutputStream(file));
                out.close();
                return testSession;
            }
            catch (Exception e) {
                System.err.println("Failed to get the repository session: ");
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
        try {
            return repository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static synchronized Session getSessionFor(String userName) throws RepositoryException {
        return repository.login((Credentials)new SimpleCredentials(userName, "password".toCharArray()));
    }

    public static synchronized void shutdown() {
        try {
            RulesRepositoryConfigurator.getInstance(null).shutdown();
        }
        catch (Exception e) {
            log.error("Could not shut down repository.", (Throwable)e);
        }
        repository = null;
    }
}

