/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.List;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.decisiontable.ColumnCentricCommand;
import org.drools.guvnor.client.decisiontable.widget.VerticalDecisionTableWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GuidedDTColumnConfig
extends FormStylePopup {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private VerticalDecisionTableWidget dtable;
    private SuggestionCompletionEngine sce;
    private ConditionCol editingCol;
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private SmallLabel operatorLabel = new SmallLabel();
    private InfoPopup fieldLabelInterpolationInfo = this.getPredicateHint();

    public static HorizontalPanel getDefaultEditor(DTColumnConfig editingCol) {
        TextBox defaultValue = new TextBox();
        defaultValue.setText(editingCol.getDefaultValue());
        CheckBox hide = new CheckBox(((Constants)GWT.create(Constants.class)).HideThisColumn());
        hide.setValue(Boolean.valueOf(editingCol.isHideColumn()));
        hide.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        defaultValue.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)defaultValue);
        hp.add((Widget)hide);
        return hp;
    }

    public GuidedDTColumnConfig(SuggestionCompletionEngine sce, VerticalDecisionTableWidget dtable, ColumnCentricCommand refreshGrid, ConditionCol col, boolean isNew) {
        this.setModal(false);
        this.dtable = dtable;
        this.sce = sce;
        this.editingCol = new ConditionCol();
        this.editingCol.setBoundName(col.getBoundName());
        this.editingCol.setConstraintValueType(col.getConstraintValueType());
        this.editingCol.setFactField(col.getFactField());
        this.editingCol.setFactType(col.getFactType());
        this.editingCol.setHeader(col.getHeader());
        this.editingCol.setOperator(col.getOperator());
        this.editingCol.setValueList(col.getValueList());
        this.editingCol.setDefaultValue(col.getDefaultValue());
        this.editingCol.setHideColumn(col.isHideColumn());
        this.editingCol.setNegated(col.isNegated());
        this.setTitle(this.constants.ConditionColumnConfiguration());
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = new ImageButton(images.edit(), this.constants.ChooseAnExistingPatternThatThisColumnAddsTo(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pattern.add((Widget)changePattern);
        this.addAttribute(this.constants.Pattern(), (Widget)pattern);
        RadioButton literal = new RadioButton("constraintValueType", this.constants.LiteralValue());
        RadioButton formula = new RadioButton("constraintValueType", this.constants.Formula());
        RadioButton predicate = new RadioButton("constraintValueType", this.constants.Predicate());
        HorizontalPanel valueTypes = new HorizontalPanel();
        valueTypes.add((Widget)literal);
        valueTypes.add((Widget)formula);
        valueTypes.add((Widget)predicate);
        this.addAttribute(this.constants.CalculationType(), (Widget)valueTypes);
        switch (this.editingCol.getConstraintValueType()) {
            case 1: {
                literal.setValue(Boolean.valueOf(true));
                break;
            }
            case 3: {
                formula.setValue(Boolean.valueOf(true));
                break;
            }
            case 5: {
                predicate.setValue(Boolean.valueOf(true));
            }
        }
        literal.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        formula.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        predicate.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel field = new HorizontalPanel();
        field.add((Widget)this.fieldLabel);
        field.add((Widget)this.fieldLabelInterpolationInfo);
        ImageButton editField = new ImageButton(images.edit(), this.constants.EditTheFieldThatThisColumnOperatesOn(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        field.add((Widget)editField);
        this.addAttribute(this.constants.Field(), (Widget)field);
        this.doFieldLabel();
        HorizontalPanel operator = new HorizontalPanel();
        operator.add((Widget)this.operatorLabel);
        ImageButton editOp = new ImageButton(images.edit(), this.constants.EditTheOperatorThatIsUsedToCompareDataWithThisField(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        operator.add((Widget)editOp);
        this.addAttribute(this.constants.Operator(), (Widget)operator);
        this.doOperatorLabel();
        TextBox valueList = new TextBox();
        valueList.setText(this.editingCol.getValueList());
        valueList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel vl = new HorizontalPanel();
        vl.add((Widget)valueList);
        vl.add((Widget)new InfoPopup(this.constants.ValueList(), this.constants.ValueListsExplanation()));
        this.addAttribute(this.constants.optionalValueList(), (Widget)vl);
        TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute(this.constants.ColumnHeaderDescription(), (Widget)header);
        this.addAttribute(this.constants.DefaultValue(), (Widget)GuidedDTColumnConfig.getDefaultEditor((DTColumnConfig)this.editingCol));
        Button apply = new Button(this.constants.ApplyChanges());
        apply.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute("", (Widget)apply);
    }

    private void applyConsTypeChange(int newType) {
        this.editingCol.setConstraintValueType(newType);
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    private boolean checkUnique(String fn, List<ConditionCol> conditionCols) {
        for (ConditionCol c : conditionCols) {
            if (!c.getBoundName().equals(fn)) continue;
            return false;
        }
        return true;
    }

    private void doFieldLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            this.fieldLabel.setText(this.constants.notNeededForPredicate());
            this.fieldLabelInterpolationInfo.setVisible(true);
        } else if (this.nil(this.editingCol.getFactType())) {
            this.fieldLabel.setText(this.constants.pleaseSelectAPatternFirst());
            this.fieldLabelInterpolationInfo.setVisible(false);
        } else if (this.nil(this.editingCol.getFactField())) {
            this.fieldLabel.setText(this.constants.pleaseSelectAField());
            this.fieldLabelInterpolationInfo.setVisible(false);
        } else {
            this.fieldLabel.setText(this.editingCol.getFactField());
        }
    }

    private void doOperatorLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            this.operatorLabel.setText(this.constants.notNeededForPredicate());
        } else if (this.nil(this.editingCol.getFactType())) {
            this.operatorLabel.setText(this.constants.pleaseSelectAPatternFirst());
        } else if (this.nil(this.editingCol.getFactField())) {
            this.operatorLabel.setText(this.constants.pleaseChooseAFieldFirst());
        } else if (this.nil(this.editingCol.getOperator())) {
            this.operatorLabel.setText(this.constants.pleaseSelectAField());
        } else {
            this.operatorLabel.setText(HumanReadable.getOperatorDisplayName((String)this.editingCol.getOperator()));
        }
    }

    private void doPatternLabel() {
        if (this.editingCol.getFactType() != null) {
            this.patternLabel.setText((this.editingCol.isNegated() ? this.constants.negatedPattern() + " " : "") + this.editingCol.getFactType() + " [" + this.editingCol.getBoundName() + "]");
        }
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    private TextBox getFieldLabel() {
        TextBox box = new TextBox();
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private InfoPopup getPredicateHint() {
        return new InfoPopup(this.constants.Predicates(), this.constants.PredicatesInfo());
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (int i = 0; i < this.dtable.getModel().getConditionCols().size(); ++i) {
            ConditionCol c = (ConditionCol)this.dtable.getModel().getConditionCols().get(i);
            if (vars.contains(c.getBoundName())) continue;
            patterns.addItem((c.isNegated() ? this.constants.negatedPattern() + " " : "") + c.getFactType() + " [" + c.getBoundName() + "]", c.getFactType() + " " + c.getBoundName() + " " + c.isNegated());
            vars.add(c.getBoundName());
        }
        return patterns;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showOperatorChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(this.constants.SetTheOperator());
        pop.setModal(false);
        String[] ops = this.sce.getOperatorCompletions(this.editingCol.getFactType(), this.editingCol.getFactField());
        ListBox box = new ListBox();
        for (int i = 0; i < ops.length; ++i) {
            box.addItem(HumanReadable.getOperatorDisplayName((String)ops[i]), ops[i]);
        }
        if (1 == this.editingCol.getConstraintValueType()) {
            box.addItem(HumanReadable.getOperatorDisplayName((String)"in"), "in");
        }
        box.addItem(this.constants.noOperator(), "");
        pop.addAttribute(this.constants.Operator(), (Widget)box);
        Button b = new Button(this.constants.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private boolean unique(String header) {
        for (ConditionCol o : this.dtable.getModel().getConditionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    protected void showChangePattern(ClickEvent w) {
        ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        FormStylePopup pop = new FormStylePopup();
        Button ok = new Button(this.constants.OK());
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)pats);
        hp.add((Widget)ok);
        pop.addAttribute(this.constants.ChooseExistingPatternToAddColumnTo(), (Widget)hp);
        pop.addAttribute("", (Widget)new HTML(this.constants.ORwithEmphasis()));
        Button createPattern = new Button(this.constants.CreateNewFactPattern());
        createPattern.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)createPattern);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showFieldChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setModal(false);
        String[] fields = this.sce.getFieldCompletions(FieldAccessorsAndMutators.ACCESSOR, this.editingCol.getFactType());
        ListBox box = new ListBox();
        for (int i = 0; i < fields.length; ++i) {
            box.addItem(fields[i]);
        }
        pop.addAttribute(this.constants.Field(), (Widget)box);
        Button b = new Button(this.constants.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showNewPatternDialog() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(this.constants.CreateANewFactPattern());
        ListBox types = new ListBox();
        for (int i = 0; i < this.sce.getFactTypes().length; ++i) {
            types.addItem(this.sce.getFactTypes()[i]);
        }
        pop.addAttribute(this.constants.FactType(), (Widget)types);
        TextBox binding = new TextBox();
        binding.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(this.constants.name(), (Widget)binding);
        CheckBox chkNegated = new CheckBox();
        pop.addAttribute(this.constants.negatePattern(), (Widget)chkNegated);
        Button ok = new Button(this.constants.OK());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    static /* synthetic */ void access$000(GuidedDTColumnConfig x0, int x1) {
        x0.applyConsTypeChange(x1);
    }

    static /* synthetic */ void access$100(GuidedDTColumnConfig x0) {
        x0.showOperatorChange();
    }

    static /* synthetic */ ConditionCol access$200(GuidedDTColumnConfig x0) {
        return x0.editingCol;
    }

    static /* synthetic */ Constants access$300(GuidedDTColumnConfig x0) {
        return x0.constants;
    }

    static /* synthetic */ boolean access$400(GuidedDTColumnConfig x0, String x1) {
        return x0.unique(x1);
    }

    static /* synthetic */ void access$500(GuidedDTColumnConfig x0) {
        x0.doOperatorLabel();
    }

    static /* synthetic */ void access$600(GuidedDTColumnConfig x0) {
        x0.doPatternLabel();
    }

    static /* synthetic */ void access$700(GuidedDTColumnConfig x0) {
        x0.doFieldLabel();
    }

    static /* synthetic */ VerticalDecisionTableWidget access$800(GuidedDTColumnConfig x0) {
        return x0.dtable;
    }

    static /* synthetic */ boolean access$900(GuidedDTColumnConfig x0, String x1, List x2) {
        return x0.checkUnique(x1, x2);
    }
}

