/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.Map;
import org.drools.guvnor.client.explorer.AbstractTree;
import org.drools.guvnor.client.explorer.ExplorerNodeConfig;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.SnapshotInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentTree
extends AbstractTree
implements OpenHandler<TreeItem> {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);

    public DeploymentTree() {
        this.name = constants.PackageSnapshots();
        this.image = images.deploy();
        this.mainTree.setAnimationEnabled(true);
        ExplorerNodeConfig.setupDeploymentTree((Tree)this.mainTree, (Map)this.itemWidgets);
        this.mainTree.addSelectionHandler((SelectionHandler)this);
        this.mainTree.addOpenHandler((OpenHandler)this);
    }

    protected Tree createTree() {
        return new Tree();
    }

    public void refreshTree() {
        this.mainTree.clear();
        this.itemWidgets.clear();
        ExplorerNodeConfig.setupDeploymentTree((Tree)this.mainTree, (Map)this.itemWidgets);
    }

    public void onSelection(SelectionEvent<TreeItem> event) {
        TreeItem item = (TreeItem)event.getSelectedItem();
        if (item.getUserObject() instanceof Object[]) {
            Object[] o = (Object[])item.getUserObject();
            String snapName = ((SnapshotInfo)o[0]).name;
            PackageConfigData conf = (PackageConfigData)o[1];
            RepositoryServiceFactory.getPackageService().listSnapshots(conf.name, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void onOpen(OpenEvent<TreeItem> event) {
        TreeItem node = (TreeItem)event.getTarget();
        if ("packageSnapshots".equals(this.itemWidgets.get(node))) {
            return;
        }
        PackageConfigData conf = (PackageConfigData)node.getUserObject();
        if (conf != null) {
            RepositoryServiceFactory.getPackageService().listSnapshots(conf.name, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }
}

