/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.ActionInsertFactWidget;
import org.drools.guvnor.client.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;

public class ActionInsertFactWidget
extends RuleModellerWidget {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private final DirtyableFlexTable layout;
    private final ActionInsertFact model;
    private final String[] fieldCompletions;
    private final String factType;
    private boolean readOnly;

    public ActionInsertFactWidget(RuleModeller mod, ActionInsertFact set) {
        this(mod, set, null);
    }

    public ActionInsertFactWidget(RuleModeller mod, ActionInsertFact set, Boolean readOnly) {
        super(mod);
        this.model = set;
        this.layout = new DirtyableFlexTable();
        this.factType = set.factType;
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        this.fieldCompletions = completions.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, set.factType);
        this.layout.setStyleName("model-builderInner-Background");
        this.readOnly = readOnly == null ? !completions.containsFactType(set.factType) : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getAssertLabel());
        this.layout.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        this.layout.getFlexCellFormatter().setColSpan(0, 0, 2);
        DirtyableFlexTable inner = new DirtyableFlexTable();
        int col = 0;
        for (int i = 0; i < this.model.fieldValues.length; ++i) {
            ActionFieldValue val = this.model.fieldValues[i];
            inner.setWidget(i, 0 + col, this.fieldSelector(val));
            inner.setWidget(i, 1 + col, this.valueEditor(val));
            int idx = i;
            ImageButton remove = new ImageButton(images.deleteItemSmall());
            remove.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (this.readOnly) continue;
            inner.setWidget(i, 2 + col, (Widget)remove);
        }
        this.layout.setWidget(1, 1, (Widget)inner);
    }

    private Widget valueEditor(ActionFieldValue val) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        DropDownData enums = completions.getEnums(this.factType, (FieldNature[])this.model.fieldValues, val.field);
        ActionValueEditor actionValueEditor = new ActionValueEditor(val, enums, this.getModeller(), val.type, this.readOnly);
        actionValueEditor.setOnChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        return actionValueEditor;
    }

    private Widget fieldSelector(ActionFieldValue val) {
        return new SmallLabel(val.field);
    }

    private Widget getAssertLabel() {
        String lbl;
        3 cl = new /* Unavailable Anonymous Inner Class!! */;
        String assertType = "assert";
        if (this.model instanceof ActionInsertLogicalFact) {
            assertType = "assertLogical";
        }
        String string = lbl = !this.model.isBound() ? HumanReadable.getActionDisplayName((String)assertType) + " <b>" + this.model.factType + "</b>" : HumanReadable.getActionDisplayName((String)assertType) + " <b>" + this.model.factType + "</b>" + " <b>[" + this.model.getBoundName() + "]</b>";
        if (this.model.fieldValues != null && this.model.fieldValues.length > 0) {
            lbl = lbl + ":";
        }
        return new ClickableLabel(lbl, (ClickHandler)cl, !this.readOnly);
    }

    protected void showAddFieldPopup(Widget w) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        FormStylePopup popup = new FormStylePopup(images.newexWiz(), this.constants.AddAField());
        ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletions.length; ++i) {
            box.addItem(this.fieldCompletions[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(this.constants.AddField(), (Widget)box);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel vn = new HorizontalPanel();
        TextBox varName = new TextBox();
        if (this.model.getBoundName() != null) {
            varName.setText(this.model.getBoundName());
        }
        Button ok = new Button(this.constants.Set());
        vn.add((Widget)varName);
        vn.add((Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.addAttribute(this.constants.BoundVariable(), (Widget)vn);
        popup.show();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    static /* synthetic */ Constants access$000(ActionInsertFactWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ ActionInsertFact access$100(ActionInsertFactWidget x0) {
        return x0.model;
    }
}

