/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.DirtyableVerticalPane;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.CompositeFactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

public class CompositeFactPatternWidget
extends RuleModellerWidget {
    protected final SuggestionCompletionEngine completions;
    protected CompositeFactPattern pattern;
    protected DirtyableFlexTable layout;
    protected Constants constants = (Constants)GWT.create(Constants.class);
    protected boolean readOnly;
    private List<RuleModellerWidget> childWidgets;

    public CompositeFactPatternWidget(RuleModeller modeller, CompositeFactPattern pattern) {
        this(modeller, pattern, null);
    }

    public CompositeFactPatternWidget(RuleModeller modeller, CompositeFactPattern pattern, Boolean readOnly) {
        super(modeller);
        this.completions = modeller.getSuggestionCompletions();
        this.pattern = pattern;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        if (readOnly != null) {
            this.readOnly = readOnly;
        } else {
            this.readOnly = false;
            if (this.pattern != null && this.pattern.getPatterns() != null) {
                IFactPattern[] patterns = this.pattern.getPatterns();
                for (int i = 0; i < patterns.length; ++i) {
                    IFactPattern p = patterns[i];
                    if (p.getFactType() == null || this.completions.containsFactType(p.getFactType())) continue;
                    this.readOnly = true;
                    break;
                }
            }
        }
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    protected void doLayout() {
        this.childWidgets = new ArrayList();
        this.layout.setWidget(0, 0, this.getCompositeLabel());
        this.layout.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.layout.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (this.pattern.getPatterns() != null) {
            DirtyableVerticalPane vert = new DirtyableVerticalPane();
            IFactPattern[] facts = this.pattern.getPatterns();
            for (int i = 0; i < facts.length; ++i) {
                RuleModellerWidget widget = this.getModeller().getWidgetFactory().getWidget(this.getModeller(), (IPattern)facts[i], Boolean.valueOf(this.readOnly));
                widget.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                this.childWidgets.add(widget);
                vert.add((Widget)widget);
            }
            this.layout.setWidget(1, 1, (Widget)vert);
        }
    }

    protected Widget getCompositeLabel() {
        2 click = new /* Unavailable Anonymous Inner Class!! */;
        String lbl = HumanReadable.getCEDisplayName((String)this.pattern.type);
        if (this.pattern.getPatterns() == null || this.pattern.getPatterns().length == 0) {
            lbl = lbl + " <font color='red'>" + this.constants.clickToAddPatterns() + "</font>";
        }
        return new ClickableLabel(lbl + ":", (ClickHandler)click, !this.readOnly);
    }

    protected void showFactTypeSelector(Widget w) {
        ListBox box = new ListBox();
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        String[] facts = completions.getFactTypes();
        box.addItem(this.constants.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        FormStylePopup popup = new FormStylePopup();
        popup.setTitle(this.constants.NewFactPattern());
        popup.addAttribute(this.constants.chooseFactType(), (Widget)box);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button fromBtn = new Button(this.constants.From());
        Button fromAccumulateBtn = new Button(this.constants.FromAccumulate());
        Button fromCollectBtn = new Button(this.constants.FromCollect());
        4 btnsClickHandler = new /* Unavailable Anonymous Inner Class!! */;
        fromBtn.addClickHandler((ClickHandler)btnsClickHandler);
        fromAccumulateBtn.addClickHandler((ClickHandler)btnsClickHandler);
        fromCollectBtn.addClickHandler((ClickHandler)btnsClickHandler);
        popup.addAttribute("", (Widget)fromBtn);
        popup.addAttribute("", (Widget)fromAccumulateBtn);
        popup.addAttribute("", (Widget)fromCollectBtn);
        popup.show();
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

