/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.ArtifactEditor;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.MessageWidget;
import org.drools.guvnor.client.ruleeditor.MetaDataWidgetNew;
import org.drools.guvnor.client.ruleeditor.RuleDocumentWidget;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbarButtonsConfigurationProvider;

public class ArtifactEditor
extends GuvnorEditor {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static ArtifactEditorBinder uiBinder = (ArtifactEditorBinder)GWT.create(ArtifactEditorBinder.class);
    @UiField(provided=true)
    final MetaDataWidgetNew metaWidget;
    @UiField(provided=true)
    final RuleDocumentWidget ruleDocumentWidget;
    @UiField
    MessageWidget messageWidget;
    public Command checkedInCommand;
    protected Artifact artifact;
    private boolean readOnly;
    private long lastSaved = System.currentTimeMillis();

    public ArtifactEditor(Artifact artifact) {
        this(artifact, false, null);
    }

    public ArtifactEditor(Artifact artifact, boolean historicalReadOnly) {
        this(artifact, historicalReadOnly, null);
    }

    public ArtifactEditor(Artifact artifact, boolean historicalReadOnly, ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider) {
        this.artifact = artifact;
        this.readOnly = historicalReadOnly || artifact.isreadonly;
        this.ruleDocumentWidget = new RuleDocumentWidget(artifact, historicalReadOnly);
        this.metaWidget = this.createMetaWidget();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setWidth("100%");
        LoadingPopup.close();
    }

    public boolean isDirty() {
        return System.currentTimeMillis() - this.lastSaved > 3600000L;
    }

    private MetaDataWidgetNew createMetaWidget() {
        return new MetaDataWidgetNew(this.artifact, this.readOnly, this.artifact.uuid, (Command)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean hasDirty() {
        return false;
    }

    public void showInfoMessage(String message) {
        this.messageWidget.showMessage(message);
    }

    public void refreshDataAndView() {
        LoadingPopup.showMessage((String)this.constants.RefreshingItem());
        RepositoryServiceFactory.getAssetService().loadRuleAsset(this.artifact.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshMetaWidgetOnly() {
        this.refreshMetaWidgetOnly(true);
    }

    private void refreshMetaWidgetOnly(boolean showBusy) {
        if (showBusy) {
            LoadingPopup.showMessage((String)this.constants.RefreshingItem());
        }
        RepositoryServiceFactory.getAssetService().loadRuleAsset(this.artifact.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

