/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.AssetCategoryEditor;
import org.drools.guvnor.client.ruleeditor.MetaDataWidgetNew;
import org.drools.guvnor.client.ruleeditor.VersionBrowser;
import org.drools.guvnor.client.security.Capabilities;
import org.drools.guvnor.client.security.CapabilitiesManager;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;

/*
 * Exception performing whole class analysis ignored.
 */
public class MetaDataWidgetNew
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private Artifact artifact;
    private boolean readOnly;
    private String uuid;
    private Command metaDataRefreshView;
    private Command fullRefreshView;
    private VerticalPanel layout = new VerticalPanel();
    AssetCategoryEditor ed;
    private FormStyleLayout currentSection;
    private String currentSectionName;

    public MetaDataWidgetNew(Artifact d, boolean readOnly, String uuid, Command metaDataRefreshView, Command fullRefreshView) {
        this.uuid = uuid;
        this.artifact = d;
        this.readOnly = readOnly;
        this.layout.setWidth("100%");
        this.metaDataRefreshView = metaDataRefreshView;
        this.fullRefreshView = fullRefreshView;
        this.initWidget((Widget)this.layout);
        this.render();
    }

    public void setMetaData(Artifact data) {
        this.artifact = data;
    }

    private void render() {
        this.layout.clear();
        this.startSection(this.constants.Metadata());
        this.addHeader(images.assetVersion(), this.artifact.name, null);
        this.loadData();
    }

    private void addHeader(ImageResource img, String name, Image edit) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new SmallLabel("<b>" + name + "</b>"));
        if (edit != null) {
            hp.add((Widget)edit);
        }
        this.currentSection.addAttribute(this.constants.Title(), (Widget)hp);
    }

    private void loadData() {
        if (this.artifact instanceof RuleAsset) {
            this.addAttribute(this.constants.CategoriesMetaData(), this.categories());
        }
        this.addAttribute(this.constants.LastModified(), this.readOnlyDate(this.artifact.lastModified));
        this.addAttribute(this.constants.ModifiedByMetaData(), (Widget)this.readOnlyText(this.artifact.lastContributor));
        this.addAttribute(this.constants.NoteMetaData(), (Widget)this.readOnlyText(this.artifact.checkinComment));
        if (!this.readOnly) {
            this.addAttribute(this.constants.CreatedOnMetaData(), this.readOnlyDate(this.artifact.dateCreated));
        }
        if (this.artifact instanceof RuleAsset) {
            this.addAttribute(this.constants.CreatedByMetaData(), (Widget)this.readOnlyText(((RuleAsset)this.artifact).metaData.creator));
            this.addAttribute(this.constants.FormatMetaData(), (Widget)new SmallLabel("<b>" + ((RuleAsset)this.artifact).metaData.format + "</b>"));
            this.addAttribute(this.constants.PackageMetaData(), this.packageEditor(((RuleAsset)this.artifact).metaData.packageName));
            this.addAttribute(this.constants.IsDisabledMetaData(), this.editableBoolean((FieldBooleanBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.DisableTip()));
        }
        this.addAttribute("UUID:", (Widget)this.readOnlyText(this.uuid));
        this.endSection(true);
        this.startSection(this.constants.VersionHistory());
        this.addAttribute(this.constants.VersionFeed(), (Widget)new HTML("<a href='" + MetaDataWidgetNew.getVersionFeed((Artifact)this.artifact) + "' target='_blank'><img src='" + new Image(images.feed()).getUrl() + "'/></a>"));
        this.addAttribute(this.constants.CurrentVersionNumber(), this.getVersionNumberLabel());
        if (!this.readOnly) {
            this.addRow((Widget)new VersionBrowser(this.uuid, !(this.artifact instanceof RuleAsset), this.fullRefreshView));
        }
        this.endSection(true);
    }

    private void addRow(Widget widget) {
        this.currentSection.addRow(widget);
    }

    private void addAttribute(String string, Widget widget) {
        this.currentSection.addAttribute(string, widget);
    }

    private void endSection() {
        this.endSection(false);
    }

    private void endSection(boolean collapsed) {
        DecoratedDisclosurePanel advancedDisclosure = new DecoratedDisclosurePanel(this.currentSectionName);
        advancedDisclosure.setWidth("100%");
        advancedDisclosure.setOpen(collapsed);
        advancedDisclosure.setContent((Widget)this.currentSection);
        this.layout.add((Widget)advancedDisclosure);
    }

    private void startSection(String name) {
        this.currentSection = new FormStyleLayout();
        this.currentSectionName = name;
    }

    private Widget packageEditor(String packageName) {
        if (this.readOnly || !CapabilitiesManager.getInstance().shouldShow(new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            return this.readOnlyText(packageName);
        }
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.setStyleName("metadata-Widget");
        horiz.add((Widget)this.readOnlyText(packageName));
        ImageButton editPackage = new ImageButton(images.edit());
        editPackage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        horiz.add((Widget)editPackage);
        return horiz;
    }

    private void showEditPackage(String pkg, ClickEvent source) {
        FormStylePopup pop = new FormStylePopup(images.packageLarge(), this.constants.MoveThisItemToAnotherPackage());
        pop.addAttribute(this.constants.CurrentPackage(), (Widget)new Label(pkg));
        RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute(this.constants.NewPackage(), (Widget)sel);
        Button ok = new Button(this.constants.ChangePackage());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private Widget getVersionNumberLabel() {
        if (this.artifact.versionNumber == 0L) {
            return new SmallLabel(this.constants.NotCheckedInYet());
        }
        return this.readOnlyText(Long.toString(this.artifact.versionNumber));
    }

    private Widget readOnlyDate(Date lastModifiedDate) {
        if (lastModifiedDate == null) {
            return null;
        }
        return new SmallLabel(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(lastModifiedDate));
    }

    private Label readOnlyText(String text) {
        SmallLabel lbl = new SmallLabel(text);
        lbl.setWidth("100%");
        return lbl;
    }

    private Widget categories() {
        this.ed = new AssetCategoryEditor(((RuleAsset)this.artifact).metaData, this.readOnly);
        return this.ed;
    }

    private Widget editableText(FieldBinding bind, String toolTip) {
        if (!this.readOnly) {
            TextBox box = new TextBox();
            box.setTitle(toolTip);
            box.setText(bind.getValue());
            box.setVisibleLength(10);
            4 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addChangeHandler((ChangeHandler)listener);
            return box;
        }
        return new Label(bind.getValue());
    }

    private Widget editableBoolean(FieldBooleanBinding bind, String toolTip) {
        if (!this.readOnly) {
            CheckBox box = new CheckBox();
            box.setTitle(toolTip);
            box.setEnabled(bind.getValue());
            5 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addClickHandler((ClickHandler)listener);
            return box;
        }
        CheckBox box = new CheckBox();
        box.setEnabled(bind.getValue());
        box.setEnabled(false);
        return box;
    }

    public Artifact getData() {
        return this.artifact;
    }

    public void refresh() {
        this.render();
    }

    static String getVersionFeed(Artifact artifact) {
        if (artifact instanceof PackageConfigData) {
            String hurl = MetaDataWidgetNew.getRESTBaseURL() + "packages/" + artifact.name + "/versions";
            return hurl;
        }
        String hurl = MetaDataWidgetNew.getRESTBaseURL() + "packages/" + ((RuleAsset)artifact).metaData.packageName + "/assets/" + artifact.name + "/versions";
        return hurl;
    }

    static String getRESTBaseURL() {
        String url = GWT.getModuleBaseURL();
        return url.replaceFirst("org.drools.guvnor.Guvnor", "rest");
    }

    static /* synthetic */ Artifact access$000(MetaDataWidgetNew x0) {
        return x0.artifact;
    }

    static /* synthetic */ void access$100(MetaDataWidgetNew x0, String x1, ClickEvent x2) {
        x0.showEditPackage(x1, x2);
    }

    static /* synthetic */ Constants access$200(MetaDataWidgetNew x0) {
        return x0.constants;
    }

    static /* synthetic */ String access$300(MetaDataWidgetNew x0) {
        return x0.uuid;
    }

    static /* synthetic */ Command access$400(MetaDataWidgetNew x0) {
        return x0.metaDataRefreshView;
    }
}

