/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid;

import java.math.BigDecimal;
import java.util.Date;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.guvnor.client.widgets.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.DTDataTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCellValueFactory<T> {
    protected static DateConverter DATE_CONVERTOR = null;
    protected SuggestionCompletionEngine sce;

    public AbstractCellValueFactory(SuggestionCompletionEngine sce) {
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        this.sce = sce;
    }

    public static void injectDateConvertor(DateConverter dc) {
        DATE_CONVERTOR = dc;
    }

    public CellValue<? extends Comparable<?>> makeCellValue(T column, int iRow, int iCol) {
        DTDataTypes dataType = this.getDataType(column);
        CellValue cell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt$DTDataTypes[dataType.ordinal()]) {
            case 1: {
                cell = this.makeNewBooleanCellValue(iRow, iCol);
                break;
            }
            case 2: {
                cell = this.makeNewDateCellValue(iRow, iCol);
                break;
            }
            case 3: {
                cell = this.makeNewNumericCellValue(iRow, iCol);
                break;
            }
            default: {
                cell = this.makeNewStringCellValue(iRow, iCol);
            }
        }
        return cell;
    }

    protected abstract DTDataTypes getDataType(T var1);

    protected CellValue<Boolean> makeNewBooleanCellValue(int iRow, int iCol) {
        CellValue cv = new CellValue((Comparable)Boolean.FALSE, iRow, iCol);
        return cv;
    }

    protected CellValue<Boolean> makeNewBooleanCellValue(int iRow, int iCol, Boolean initialValue) {
        CellValue cv = this.makeNewBooleanCellValue(iRow, iCol);
        if (initialValue != null) {
            cv.setValue((Object)initialValue);
        }
        return cv;
    }

    protected CellValue<Date> makeNewDateCellValue(int iRow, int iCol) {
        CellValue cv = new CellValue(null, iRow, iCol);
        return cv;
    }

    protected CellValue<Date> makeNewDateCellValue(int iRow, int iCol, Date initialValue) {
        CellValue cv = this.makeNewDateCellValue(iRow, iCol);
        if (initialValue != null) {
            cv.setValue((Object)initialValue);
        }
        return cv;
    }

    protected CellValue<String> makeNewDialectCellValue(int iRow, int iCol) {
        CellValue cv = new CellValue((Comparable)((Object)"java"), iRow, iCol);
        return cv;
    }

    protected CellValue<String> makeNewDialectCellValue(int iRow, int iCol, String initialValue) {
        CellValue cv = this.makeNewDialectCellValue(iRow, iCol);
        if (initialValue != null) {
            cv.setValue((Object)initialValue);
        }
        return cv;
    }

    protected CellValue<BigDecimal> makeNewNumericCellValue(int iRow, int iCol) {
        CellValue cv = new CellValue(null, iRow, iCol);
        return cv;
    }

    protected CellValue<BigDecimal> makeNewNumericCellValue(int iRow, int iCol, BigDecimal initialValue) {
        CellValue cv = this.makeNewNumericCellValue(iRow, iCol);
        if (initialValue != null) {
            cv.setValue((Object)initialValue);
        }
        return cv;
    }

    protected CellValue<String> makeNewStringCellValue(int iRow, int iCol) {
        CellValue cv = new CellValue(null, iRow, iCol);
        return cv;
    }

    protected CellValue<String> makeNewStringCellValue(int iRow, int iCol, Object initialValue) {
        CellValue cv = this.makeNewStringCellValue(iRow, iCol);
        if (initialValue != null && !initialValue.equals("")) {
            cv.setValue((Object)initialValue.toString());
        }
        return cv;
    }
}

