/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.SimpleEventBus;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridCellValueAdaptor;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicBaseColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.SortConfiguration;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicDataRow;
import org.drools.guvnor.client.widgets.tables.SortDirection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicColumn<T>
extends DynamicBaseColumn<T>
implements HasValueChangeHandlers<SortConfiguration> {
    private int columnIndex = 0;
    private T modelColumn;
    private Boolean isVisible = new Boolean(true);
    private Boolean isSystemControlled = new Boolean(false);
    private SortConfiguration sortConfig = new SortConfiguration();
    private int width = 100;
    private SimpleEventBus seb = new SimpleEventBus();

    public DynamicColumn(T modelColumn, DecoratedGridCellValueAdaptor<? extends Comparable<?>, T> cell, int columnIndex) {
        this(modelColumn, cell, columnIndex, false, true);
    }

    public DynamicColumn(T modelColumn, DecoratedGridCellValueAdaptor<? extends Comparable<?>, T> cell, int columnIndex, boolean isSystemControlled, boolean isSortable) {
        super(cell);
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null");
        }
        if (columnIndex < 0) {
            throw new IllegalArgumentException("columnIndex cannot be less than zero");
        }
        this.modelColumn = modelColumn;
        this.columnIndex = columnIndex;
        this.sortConfig.setSortable(Boolean.valueOf(isSortable));
        this.isSystemControlled = isSystemControlled;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<SortConfiguration> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        return this.seb.addHandler(ValueChangeEvent.getType(), handler);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DynamicColumn)) {
            return false;
        }
        DynamicColumn c = (DynamicColumn)o;
        return c.columnIndex == this.columnIndex && c.modelColumn.equals(this.modelColumn) && c.isVisible.equals(this.isVisible) && c.isSystemControlled.equals(this.isSystemControlled) && c.sortConfig.getSortDirection() == this.sortConfig.getSortDirection() && c.sortConfig.isSortable() == this.sortConfig.isSortable() && c.sortConfig.getSortIndex() == this.sortConfig.getSortIndex() && c.width == this.width;
    }

    public void fireEvent(GwtEvent<?> event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        this.seb.fireEvent(event);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public T getModelColumn() {
        return (T)this.modelColumn;
    }

    public SortConfiguration getSortConfiguration() {
        return this.sortConfig;
    }

    public SortDirection getSortDirection() {
        return this.sortConfig.getSortDirection();
    }

    public int getSortIndex() {
        return this.sortConfig.getSortIndex();
    }

    public CellValue<?> getValue(DynamicDataRow object) {
        return object.get(this.columnIndex);
    }

    public int getWidth() {
        return this.width;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.columnIndex;
        hash = 31 * hash + this.modelColumn.hashCode();
        hash = 31 * hash + this.isVisible.hashCode();
        hash = 31 * hash + this.isSystemControlled.hashCode();
        hash = 31 * hash + this.sortConfig.getSortDirection().hashCode();
        hash = 31 * hash + this.sortConfig.isSortable().hashCode();
        hash = 31 * hash + this.sortConfig.getSortIndex();
        hash = 31 * hash + this.width;
        return hash;
    }

    public boolean isSortable() {
        return this.sortConfig.isSortable();
    }

    public boolean isSystemControlled() {
        return this.isSystemControlled;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setColumnIndex(int columnIndex) {
        if (columnIndex < 0) {
            throw new IllegalArgumentException("columnIndex cannot be less than zero");
        }
        this.columnIndex = columnIndex;
        this.sortConfig.setColumnIndex(columnIndex);
    }

    public void setSortable(boolean isSortable) {
        this.sortConfig.setSortable(Boolean.valueOf(isSortable));
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.sortConfig);
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortConfig.setSortDirection(sortDirection);
        if (sortDirection == SortDirection.NONE) {
            this.sortConfig.setSortIndex(-1);
        }
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.sortConfig);
    }

    public void setSortIndex(int sortIndex) {
        if (sortIndex < 0) {
            throw new IllegalArgumentException("sortIndex cannot be less than zero");
        }
        this.sortConfig.setSortIndex(sortIndex);
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.sortConfig);
    }

    public void setSystemControlled(boolean isSystemControlled) {
        this.isSystemControlled = isSystemControlled;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void setWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        this.width = width;
    }
}

