/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.AbstractAssetPageRow;
import org.drools.guvnor.client.ruleeditor.MultiViewRow;
import org.drools.guvnor.client.rulelist.OpenItemCommand;
import org.drools.guvnor.client.widgets.tables.AbstractAssetPagedTable;
import org.drools.guvnor.client.widgets.tables.AbstractPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.SelectionColumn;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAssetPagedTable<T extends AbstractAssetPageRow>
extends AbstractPagedTable<T> {
    protected static final Constants constants = (Constants)GWT.create(Constants.class);
    private static AssetPagedTableBinder uiBinder = (AssetPagedTableBinder)GWT.create(AssetPagedTableBinder.class);
    @UiField
    protected Image feedImage;
    protected Set<Command> unloadListenerSet = new HashSet();
    protected MultiSelectionModel<T> selectionModel;
    protected final OpenItemCommand openSelectedCommand;
    protected String feedURL;

    public AbstractAssetPagedTable(int pageSize, OpenItemCommand editEvent) {
        this(pageSize, editEvent, null);
    }

    public AbstractAssetPagedTable(int pageSize, OpenItemCommand openSelectedCommand, String feedURL) {
        super(pageSize);
        this.openSelectedCommand = openSelectedCommand;
        this.feedURL = feedURL;
        if (this.feedURL == null || "".equals(feedURL)) {
            this.feedImage.setVisible(false);
        }
    }

    public void addUnloadListener(Command unloadListener) {
        this.unloadListenerSet.add(unloadListener);
    }

    public String[] getSelectedRowUUIDs() {
        Set selectedRows = this.selectionModel.getSelectedSet();
        if (selectedRows.size() == 0) {
            return null;
        }
        String[] uuids = new String[selectedRows.size()];
        int rowCount = 0;
        for (AbstractAssetPageRow row : selectedRows) {
            uuids[rowCount++] = row.getUuid();
        }
        return uuids;
    }

    @UiHandler(value={"openSelectedToSingleTabButton"})
    public void openSelectedToSingleTab(ClickEvent e) {
        Set selectedSet = this.selectionModel.getSelectedSet();
        ArrayList<MultiViewRow> multiViewRowList = new ArrayList<MultiViewRow>(selectedSet.size());
        for (AbstractAssetPageRow selected : selectedSet) {
            MultiViewRow row = new MultiViewRow();
            row.uuid = selected.getUuid();
            row.format = selected.getFormat();
            row.name = selected.getName();
            multiViewRowList.add(row);
        }
        this.openSelectedCommand.open(multiViewRowList.toArray(new MultiViewRow[multiViewRowList.size()]));
    }

    public void refresh() {
        this.selectionModel.clear();
        this.cellTable.setVisibleRangeAndClearData(this.cellTable.getVisibleRange(), true);
    }

    protected void doCellTable() {
        1 providesKey = new /* Unavailable Anonymous Inner Class!! */;
        this.cellTable = new CellTable((ProvidesKey)providesKey);
        this.selectionModel = new MultiSelectionModel((ProvidesKey)providesKey);
        this.cellTable.setSelectionModel((SelectionModel)this.selectionModel);
        SelectionColumn.createAndAddSelectionColumn((CellTable)this.cellTable);
        ColumnPicker columnPicker = new ColumnPicker(this.cellTable);
        SortableHeaderGroup sortableHeaderGroup = new SortableHeaderGroup(this.cellTable);
        2 uuidNumberColumn = new /* Unavailable Anonymous Inner Class!! */;
        columnPicker.addColumn((Column)uuidNumberColumn, (Header)new SortableHeader(sortableHeaderGroup, constants.uuid(), (Column)uuidNumberColumn), false);
        this.addAncillaryColumns(columnPicker, sortableHeaderGroup);
        3 openColumn = new /* Unavailable Anonymous Inner Class!! */;
        openColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        columnPicker.addColumn((Column)openColumn, (Header)new TextHeader(constants.Open()), true);
        this.cellTable.setWidth("100%");
        this.columnPickerButton = columnPicker.createToggleButton();
    }

    protected void onUnload() {
        super.onUnload();
        for (Command unloadListener : this.unloadListenerSet) {
            unloadListener.execute();
        }
    }

    protected void setDataProvider(AsyncDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
        this.dataProvider.addDataDisplay((HasData)this.cellTable);
    }

    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"feedImage"})
    void openFeed(ClickEvent e) {
        if (!this.feedImage.isVisible() || this.feedURL == null || "".equals(this.feedURL)) {
            return;
        }
        Window.open((String)this.feedURL, (String)"_blank", null);
    }

    @UiHandler(value={"openSelectedButton"})
    void openSelected(ClickEvent e) {
        Set selectedSet = this.selectionModel.getSelectedSet();
        for (AbstractAssetPageRow selected : selectedSet) {
            this.openSelectedCommand.open(selected.getUuid());
        }
    }

    @UiHandler(value={"refreshButton"})
    void refresh(ClickEvent e) {
        this.refresh();
    }
}

