/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.AssetItem;

public class AssetTemplateCreator {
    private static final LoggingHelper log = LoggingHelper.getLogger(AssetTemplateCreator.class);

    protected void applyPreBuiltTemplates(String ruleName, String format, AssetItem asset) {
        if (format.equals("dslr")) {
            asset.updateContent("when\n\nthen\n");
        } else if (format.equals("function")) {
            asset.updateContent("function <returnType> " + ruleName + "(<args here>) {\n\n\n}");
        } else if (format.equals("dsl")) {
            asset.updateContent("[when]Condition sentence template {var}=rule language mapping {var}\n[then]Action sentence template=rule language mapping");
        } else if (format.equals("xls")) {
            asset.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/SampleDecisionTable.xls"));
            asset.updateBinaryContentAttachmentFileName("SampleDecisionTable.xls");
        } else if (format.equals("drl")) {
            asset.updateContent("when\n\t#conditions\nthen\n\t#actions");
        } else if (!format.equals("enumeration") && format.equals("springContext")) {
            try {
                ByteArrayOutputStream outContent = new ByteArrayOutputStream();
                BufferedInputStream inContent = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream("spring-context-sample.xml"));
                IOUtils.copy((InputStream)inContent, (OutputStream)outContent);
                asset.updateContent(outContent.toString());
            }
            catch (IOException ex) {
                log.error("Error reading spring-context-sample.xml", (Throwable)ex);
                throw new IllegalArgumentException("Error reading spring-context-sample.xml");
            }
        }
    }
}

