/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.drools.guvnor.client.rpc.AdminArchivedPageRow;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.builder.pagerow.ArchivedAssetPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.AssetPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.QuickFindPageRowBuilder;
import org.drools.guvnor.server.contenthandler.BPMN2ProcessHandler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.contenthandler.IValidating;
import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.util.AssetFormatHelper;
import org.drools.guvnor.server.util.AssetLockManager;
import org.drools.guvnor.server.util.BuilderResultHelper;
import org.drools.guvnor.server.util.Discussion;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.MetaDataMapper;
import org.drools.guvnor.server.util.ServiceRowSizeHelper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.VersionableItem;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.server.RepositoryAssetOperations")
@AutoCreate
public class RepositoryAssetOperations {
    private RulesRepository repository;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryAssetOperations.class);

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    public String renameAsset(String uuid, String newName) {
        return this.getRulesRepository().renameAsset(uuid, newName);
    }

    protected BuilderResult buildAsset(RuleAsset asset) {
        BuilderResult result = new BuilderResult();
        try {
            ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
            BuilderResultHelper builderResultHelper = new BuilderResultHelper();
            if (asset.metaData.isBinary()) {
                AssetItem item = this.getRulesRepository().loadAssetByUUID(asset.uuid);
                handler.storeAssetContent(asset, item);
                if (handler instanceof IValidating) {
                    return ((IValidating)handler).validateAsset(item);
                }
                ContentPackageAssembler asm = new ContentPackageAssembler(item);
                if (!asm.hasErrors()) {
                    return null;
                }
                result.setLines(builderResultHelper.generateBuilderResults(asm));
            } else {
                if (handler instanceof IValidating) {
                    return ((IValidating)handler).validateAsset(asset);
                }
                PackageItem packageItem = this.getRulesRepository().loadPackageByUUID(asset.metaData.packageUUID);
                ContentPackageAssembler asm = new ContentPackageAssembler(asset, packageItem);
                if (!asm.hasErrors()) {
                    return null;
                }
                result.setLines(builderResultHelper.generateBuilderResults(asm));
            }
        }
        catch (Exception e) {
            log.error("Unable to build asset.", (Throwable)e);
            result = new BuilderResult();
            BuilderResultLine res = new BuilderResultLine();
            res.setAssetName(asset.name);
            res.setAssetFormat(asset.metaData.format);
            res.setMessage("Unable to validate this asset. (Check log for detailed messages).");
            res.setUuid(asset.uuid);
            result.getLines().add(res);
            return result;
        }
        return result;
    }

    protected TableDataResult loadItemHistory(VersionableItem item) {
        Iterator it = item.getHistory();
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        while (it.hasNext()) {
            VersionableItem historical = (VersionableItem)it.next();
            long versionNumber = historical.getVersionNumber();
            if (!this.isHistory(item, versionNumber)) continue;
            result.add(this.createHistoricalRow(historical));
        }
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        return table;
    }

    private boolean isHistory(VersionableItem item, long versionNumber) {
        return versionNumber != 0L;
    }

    private TableDataRow createHistoricalRow(VersionableItem historical) {
        DateFormat dateFormatter = DateFormat.getInstance();
        TableDataRow tableDataRow = new TableDataRow();
        tableDataRow.id = historical.getVersionSnapshotUUID();
        tableDataRow.values = new String[4];
        tableDataRow.values[0] = Long.toString(historical.getVersionNumber());
        tableDataRow.values[1] = historical.getCheckinComment();
        tableDataRow.values[2] = dateFormatter.format(historical.getLastModified().getTime());
        tableDataRow.values[3] = historical.getStateDescription();
        return tableDataRow;
    }

    protected TableDataResult loadArchivedAssets(int skip, int numRows) {
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        AssetItemFilter filter = new AssetItemFilter();
        AssetItemIterator it = this.getRulesRepository().findArchivedAssets();
        it.skip((long)skip);
        int count = 0;
        while (it.hasNext()) {
            AssetItem archived = it.next();
            if (filter.accept((Object)archived, "read")) {
                result.add(this.createArchivedRow(archived));
                ++count;
            }
            if (count != numRows) continue;
            break;
        }
        return this.createArchivedTable(result, it);
    }

    private TableDataRow createArchivedRow(AssetItem archived) {
        TableDataRow row = new TableDataRow();
        row.id = archived.getUUID();
        row.values = new String[5];
        row.values[0] = archived.getName();
        row.values[1] = archived.getFormat();
        row.values[2] = archived.getPackageName();
        row.values[3] = archived.getLastContributor();
        row.values[4] = Long.toString(archived.getLastModified().getTime().getTime());
        return row;
    }

    private TableDataResult createArchivedTable(List<TableDataRow> result, AssetItemIterator it) {
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        table.currentPosition = it.getPosition();
        table.total = it.getSize();
        table.hasNext = it.hasNext();
        return table;
    }

    protected PageResponse<AdminArchivedPageRow> loadArchivedAssets(PageRequest request) {
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getRulesRepository().findArchivedAssets();
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        long totalRowsCount = iterator.getSize();
        PageResponse response = new PageResponse();
        ArchivedAssetPageRowBuilder archivedAssetPageRowBuilder = new ArchivedAssetPageRowBuilder();
        List rowList = archivedAssetPageRowBuilder.createRows(request, (Iterator)iterator);
        boolean bHasMoreRows = iterator.hasNext();
        response.setStartRowIndex(request.getStartRowIndex());
        response.setPageRowList(rowList);
        response.setLastPage(!bHasMoreRows);
        ServiceRowSizeHelper serviceRowSizeHelper = new ServiceRowSizeHelper();
        serviceRowSizeHelper.fixTotalRowSize(request, response, totalRowsCount, rowList.size(), bHasMoreRows);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Searched for Archived Assests in " + methodDuration + " ms.");
        return response;
    }

    protected TableDataResult listAssets(String packageUuid, String[] formats, int skip, int numRows, String tableConfig) {
        long start = System.currentTimeMillis();
        PackageItem pkg = this.getRulesRepository().loadPackageByUUID(packageUuid);
        AssetItemIterator it = formats.length > 0 ? pkg.listAssetsByFormat(formats) : pkg.listAssetsNotOfFormat(AssetFormatHelper.listRegisteredTypes());
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        log.debug("time for asset list load: " + (System.currentTimeMillis() - start));
        return handler.loadRuleListTable(it, skip, numRows);
    }

    protected TableDataResult quickFindAsset(String searchText, boolean searchArchived, int skip, int numRows) throws SerializationException {
        String search = searchText.replace('*', '%');
        if (!search.endsWith("%")) {
            search = search + "%";
        }
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        long start = System.currentTimeMillis();
        AssetItemIterator it = this.getRulesRepository().findAssetsByName(search, searchArchived);
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        AssetItemFilter filter = new AssetItemFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!filter.accept((Object)ai, "package.readonly")) continue;
            resultList.add(ai);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    protected TableDataResult queryFullText(String text, boolean seekArchived, int skip, int numRows) throws SerializationException {
        AssetItemIterator it = this.getRulesRepository().queryFullText(text, seekArchived);
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        PackageFilter filter = new PackageFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            PackageConfigData data = new PackageConfigData();
            data.uuid = ai.getPackage().getUUID();
            if (!filter.accept((Object)data, "package.readonly")) continue;
            resultList.add(ai);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    protected String buildAssetSource(RuleAsset asset) throws SerializationException {
        ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
        StringBuilder stringBuilder = new StringBuilder();
        if (handler.isRuleAsset()) {
            BRMSPackageBuilder builder = new BRMSPackageBuilder();
            PackageItem packageItem = this.getRulesRepository().loadPackage(asset.metaData.packageName);
            builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)packageItem, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
            if (asset.metaData.isBinary()) {
                AssetItem item = this.getRulesRepository().loadAssetByUUID(asset.uuid);
                handler.storeAssetContent(asset, item);
                ((IRuleAsset)handler).assembleDRL(builder, item, stringBuilder);
            } else {
                ((IRuleAsset)handler).assembleDRL(builder, asset, stringBuilder);
            }
        } else if (handler.getClass().getName().equals("org.drools.guvnor.server.contenthandler.BPMN2ProcessHandler")) {
            BPMN2ProcessHandler bpmn2handler = (BPMN2ProcessHandler)handler;
            bpmn2handler.assembleProcessSource(asset.content, stringBuilder);
        }
        return stringBuilder.toString();
    }

    protected PageResponse<AssetPageRow> findAssetPage(AssetPageRequest request) {
        AssetItemIterator it;
        log.debug("Finding asset page of packageUuid (" + request.getPackageUuid() + ")");
        long start = System.currentTimeMillis();
        PackageItem packageItem = this.getRulesRepository().loadPackageByUUID(request.getPackageUuid());
        if (request.getFormatInList() != null) {
            if (request.getFormatIsRegistered() != null) {
                throw new IllegalArgumentException("Combining formatInList and formatIsRegistered is not yet supported.");
            }
            it = packageItem.listAssetsByFormat(request.getFormatInList());
        } else {
            it = request.getFormatIsRegistered() != null ? packageItem.listAssetsNotOfFormat(AssetFormatHelper.listRegisteredTypes()) : packageItem.queryAssets("");
        }
        long totalRowsCount = it.getSize();
        PageResponse response = new PageResponse();
        AssetPageRowBuilder assetPageRowBuilder = new AssetPageRowBuilder();
        List rowList = assetPageRowBuilder.createRows((PageRequest)request, it);
        boolean bHasMoreRows = it.hasNext();
        response.setStartRowIndex(request.getStartRowIndex());
        response.setPageRowList(rowList);
        response.setLastPage(!bHasMoreRows);
        ServiceRowSizeHelper serviceRowSizeHelper = new ServiceRowSizeHelper();
        serviceRowSizeHelper.fixTotalRowSize((PageRequest)request, response, totalRowsCount, rowList.size(), bHasMoreRows);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Found asset page of packageUuid (" + request.getPackageUuid() + ") in " + methodDuration + " ms.");
        return response;
    }

    protected PageResponse<QueryPageRow> quickFindAsset(QueryPageRequest request) {
        String search = request.getSearchText().replace('*', '%');
        if (!search.startsWith("%")) {
            search = "%" + search;
        }
        if (!search.endsWith("%")) {
            search = search + "%";
        }
        long start = System.currentTimeMillis();
        AssetItemIterator it = this.getRulesRepository().findAssetsByName(search, request.isSearchArchived().booleanValue());
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        long totalRowsCount = it.getSize();
        PageResponse response = new PageResponse();
        QuickFindPageRowBuilder quickFindPageRowBuilder = new QuickFindPageRowBuilder();
        List rowList = quickFindPageRowBuilder.createRows((PageRequest)request, (Iterator)it);
        boolean bHasMoreRows = it.hasNext();
        response.setStartRowIndex(request.getStartRowIndex());
        response.setPageRowList(rowList);
        response.setLastPage(!bHasMoreRows);
        ServiceRowSizeHelper serviceRowSizeHelper = new ServiceRowSizeHelper();
        serviceRowSizeHelper.fixTotalRowSize((PageRequest)request, response, totalRowsCount, rowList.size(), bHasMoreRows);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Queried repository (Quick Find) for (" + search + ") in " + methodDuration + " ms.");
        return response;
    }

    protected void lockAsset(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        String userName = Contexts.isApplicationContextActive() ? Identity.instance().getCredentials().getUsername() : "anonymous";
        log.info("Locking asset uuid=" + uuid + " for user [" + userName + "]");
        alm.lockAsset(uuid, userName);
    }

    protected void unLockAsset(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        log.info("Unlocking asset [" + uuid + "]");
        alm.unLockAsset(uuid);
    }

    protected String getAssetLockerUserName(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        String userName = alm.getAssetLockerUserName(uuid);
        log.info("Asset locked by [" + userName + "]");
        return userName;
    }

    protected RuleAsset loadAsset(AssetItem item) throws SerializationException {
        RuleAsset asset = new RuleAsset();
        asset.uuid = item.getUUID();
        asset.name = item.getName();
        asset.description = item.getDescription();
        asset.lastModified = item.getLastModified().getTime();
        asset.lastContributor = item.getLastContributor();
        asset.state = item.getState() != null ? item.getState().getName() : "";
        asset.dateCreated = item.getCreatedDate().getTime();
        asset.checkinComment = item.getCheckinComment();
        asset.versionNumber = item.getVersionNumber();
        asset.metaData = this.populateMetaData(item);
        ContentHandler handler = ContentManager.getHandler((String)asset.metaData.format);
        handler.retrieveAssetContent(asset, item.getPackage(), item);
        return asset;
    }

    MetaData populateMetaData(AssetItem item) {
        MetaData meta = this.populateMetaData((VersionableItem)item);
        meta.packageName = item.getPackageName();
        meta.packageUUID = item.getPackage().getUUID();
        meta.setBinary(item.isBinary());
        List categories = item.getCategories();
        this.fillMetaCategories(meta, categories);
        meta.dateEffective = this.calendarToDate(item.getDateEffective());
        meta.dateExpired = this.calendarToDate(item.getDateExpired());
        return meta;
    }

    MetaData populateMetaData(VersionableItem item) {
        MetaData meta = new MetaData();
        MetaDataMapper metaDataMapper = MetaDataMapper.getInstance();
        metaDataMapper.copyToMetaData(meta, (Object)item);
        return meta;
    }

    private void fillMetaCategories(MetaData meta, List<CategoryItem> categories) {
        meta.categories = new String[categories.size()];
        for (int i = 0; i < meta.categories.length; ++i) {
            CategoryItem cat = categories.get(i);
            meta.categories[i] = cat.getFullPath();
        }
    }

    private Date calendarToDate(Calendar createdDate) {
        if (createdDate == null) {
            return null;
        }
        return createdDate.getTime();
    }

    protected void clearAllDiscussionsForAsset(String assetId) {
        RulesRepository repo = this.getRulesRepository();
        AssetItem asset = repo.loadAssetByUUID(assetId);
        asset.updateStringProperty("", "discussion");
        repo.save();
        this.push("discussion", assetId);
    }

    protected List<DiscussionRecord> addToDiscussionForAsset(String assetId, String comment) {
        RulesRepository repo = this.getRulesRepository();
        AssetItem asset = repo.loadAssetByUUID(assetId);
        Discussion dp = new Discussion();
        List discussion = dp.fromString(asset.getStringProperty("discussion"));
        discussion.add(new DiscussionRecord(repo.getSession().getUserID(), StringEscapeUtils.escapeXml((String)comment)));
        asset.updateStringProperty(dp.toString(discussion), "discussion", false);
        repo.save();
        this.push("discussion", assetId);
        MailboxService.getInstance().recordItemUpdated(asset);
        return discussion;
    }

    private void push(String messageType, String message) {
        Backchannel.getInstance().publish(new PushResponse(messageType, message));
    }
}

