/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRequest;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageResponse;
import org.drools.guvnor.client.rpc.SnapshotDiff;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.RepositoryPackageOperations;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.builder.pagerow.SnapshotComparisonPageRowBuilder;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.util.BRMSSuggestionCompletionLoader;
import org.drools.guvnor.server.util.BuilderResultHelper;
import org.drools.guvnor.server.util.ClassicDRLImporter;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.PackageConfigDataFactory;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Name(value="org.drools.guvnor.server.RepositoryPackageOperations")
@AutoCreate
public class RepositoryPackageOperations {
    private static final int MAX_RULES_TO_SHOW_IN_PACKAGE_LIST = 5000;
    private RulesRepository repository;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryPackageOperations.class);

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    protected PackageConfigData[] listPackages(boolean archive, String workspace, RepositoryFilter filter) {
        ArrayList result = new ArrayList();
        PackageIterator pkgs = this.getRulesRepository().listPackages();
        this.handleIteratePackages(archive, workspace, filter, result, pkgs);
        this.sortPackages(result);
        return result.toArray(new PackageConfigData[result.size()]);
    }

    private void handleIteratePackages(boolean archive, String workspace, RepositoryFilter filter, List<PackageConfigData> result, PackageIterator pkgs) {
        pkgs.setArchivedIterator(archive);
        while (pkgs.hasNext()) {
            PackageItem pkg = pkgs.next();
            PackageConfigData data = new PackageConfigData();
            data.uuid = pkg.getUUID();
            data.name = pkg.getName();
            data.archived = pkg.isArchived();
            data.workspaces = pkg.getWorkspaces();
            this.handleIsPackagesListed(archive, workspace, filter, result, data);
            data.subPackages = this.listSubPackages(pkg, archive, null, filter);
        }
    }

    private PackageConfigData[] listSubPackages(PackageItem parentPkg, boolean archive, String workspace, RepositoryFilter filter) {
        LinkedList children = new LinkedList();
        PackageIterator pkgs = parentPkg.listSubPackages();
        this.handleIteratePackages(archive, workspace, filter, children, pkgs);
        this.sortPackages(children);
        return children.toArray(new PackageConfigData[children.size()]);
    }

    void sortPackages(List<PackageConfigData> result) {
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleIsPackagesListed(boolean archive, String workspace, RepositoryFilter filter, List<PackageConfigData> result, PackageConfigData data) {
        if (!(archive || filter != null && !filter.accept((Object)data, "package.readonly") || workspace != null && !this.isWorkspace(workspace, data.workspaces))) {
            result.add(data);
        } else if (archive && data.archived && (filter == null || filter.accept((Object)data, "package.readonly")) && (workspace == null || this.isWorkspace(workspace, data.workspaces))) {
            result.add(data);
        }
    }

    private boolean isWorkspace(String workspace, String[] workspaces) {
        for (String w : workspaces) {
            if (!w.equals(workspace)) continue;
            return true;
        }
        return false;
    }

    protected PackageConfigData loadGlobalPackage() {
        PackageItem item = this.getRulesRepository().loadGlobalArea();
        PackageConfigData data = PackageConfigDataFactory.createPackageConfigDataWithOutDependencies((PackageItem)item);
        if (data.isSnapshot) {
            data.snapshotName = item.getSnapshotName();
        }
        return data;
    }

    protected String copyPackage(String sourcePackageName, String destPackageName) throws SerializationException {
        try {
            log.info("USER:" + this.getCurrentUserName() + " COPYING package [" + sourcePackageName + "] to  package [" + destPackageName + "]");
            return this.getRulesRepository().copyPackage(sourcePackageName, destPackageName);
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to copy package.", (Throwable)e);
            throw e;
        }
    }

    protected void removePackage(String uuid) {
        try {
            PackageItem item = this.getRulesRepository().loadPackageByUUID(uuid);
            log.info("USER:" + this.getCurrentUserName() + " REMOVEING package [" + item.getName() + "]");
            item.remove();
            this.getRulesRepository().save();
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to remove package.", (Throwable)e);
            throw e;
        }
    }

    protected String renamePackage(String uuid, String newName) {
        log.info("USER:" + this.getCurrentUserName() + " RENAMING package [UUID: " + uuid + "] to package [" + newName + "]");
        return this.getRulesRepository().renamePackage(uuid, newName);
    }

    protected byte[] exportPackages(String packageName) {
        log.info("USER:" + this.getCurrentUserName() + " export package [name: " + packageName + "] ");
        byte[] result = null;
        try {
            result = this.getRulesRepository().dumpPackageFromRepositoryXml(packageName);
        }
        catch (PathNotFoundException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        return result;
    }

    protected void importPackages(byte[] byteArray, boolean importAsNew) {
        this.getRulesRepository().importPackageToRepository(byteArray, importAsNew);
    }

    protected String createPackage(String name, String description, String[] workspace) throws RulesRepositoryException {
        log.info("USER: " + this.getCurrentUserName() + " CREATING package [" + name + "]");
        PackageItem item = this.getRulesRepository().createPackage(name, description, workspace);
        return item.getUUID();
    }

    protected String createSubPackage(String name, String description, String parentNode) throws SerializationException {
        log.info("USER: " + this.getCurrentUserName() + " CREATING subPackage [" + name + "], parent [" + parentNode + "]");
        PackageItem item = this.getRulesRepository().createSubPackage(name, description, parentNode);
        return item.getUUID();
    }

    protected PackageConfigData loadPackageConfig(PackageItem packageItem) {
        PackageConfigData data = PackageConfigDataFactory.createPackageConfigDataWithDependencies((PackageItem)packageItem);
        if (data.isSnapshot) {
            data.snapshotName = packageItem.getSnapshotName();
        }
        return data;
    }

    public ValidatedResponse validatePackageConfiguration(PackageConfigData data) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " validatePackageConfiguration package [" + data.name + "]");
        PackageItem item = this.getRulesRepository().loadPackage(data.name);
        RuleBaseCache.getInstance().remove(data.uuid);
        BRMSSuggestionCompletionLoader loader = this.createBRMSSuggestionCompletionLoader();
        loader.getSuggestionEngine(item, data.header);
        return this.validateBRMSSuggestionCompletionLoaderResponse(loader);
    }

    public void savePackage(PackageConfigData data) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " SAVING package [" + data.name + "]");
        PackageItem item = this.getRulesRepository().loadPackage(data.name);
        boolean unarchived = !data.archived && item.isArchived();
        Calendar packageLastModified = item.getLastModified();
        DroolsHeader.updateDroolsHeader((String)data.header, (PackageItem)item);
        this.updateCategoryRules(data, item);
        item.updateExternalURI(data.externalURI);
        item.updateDescription(data.description);
        item.archiveItem(data.archived);
        item.updateBinaryUpToDate(false);
        RuleBaseCache.getInstance().remove(data.uuid);
        item.checkin(data.description);
        if (data.archived) {
            this.handleArchivedForSavePackage(data, item);
        } else if (unarchived) {
            this.handleUnarchivedForSavePackage(data, item, packageLastModified);
        }
    }

    BRMSSuggestionCompletionLoader createBRMSSuggestionCompletionLoader() {
        return new BRMSSuggestionCompletionLoader();
    }

    void updateCategoryRules(PackageConfigData data, PackageItem item) {
        KeyValueTO keyValueTO = RepositoryPackageOperations.convertMapToCsv((Map)data.catRules);
        item.updateCategoryRules(keyValueTO.getKeys(), keyValueTO.getValues());
    }

    private static KeyValueTO convertMapToCsv(Map map) {
        StringBuilder keysBuilder = new StringBuilder();
        StringBuilder valuesBuilder = new StringBuilder();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            if (keysBuilder.length() > 0) {
                keysBuilder.append(",");
            }
            if (valuesBuilder.length() > 0) {
                valuesBuilder.append(",");
            }
            keysBuilder.append(entry.getKey());
            valuesBuilder.append(entry.getValue());
        }
        return new KeyValueTO(keysBuilder.toString(), valuesBuilder.toString());
    }

    void handleArchivedForSavePackage(PackageConfigData data, PackageItem item) {
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem assetItem = (AssetItem)iter.next();
            if (assetItem.isArchived()) continue;
            assetItem.archiveItem(true);
            assetItem.checkin(data.description);
        }
    }

    void handleUnarchivedForSavePackage(PackageConfigData data, PackageItem item, Calendar packageLastModified) {
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem assetItem = (AssetItem)iter.next();
            if (assetItem.getLastModified().compareTo(packageLastModified) < 0) continue;
            assetItem.archiveItem(false);
            assetItem.checkin(data.description);
        }
    }

    private ValidatedResponse validateBRMSSuggestionCompletionLoaderResponse(BRMSSuggestionCompletionLoader loader) {
        ValidatedResponse res = new ValidatedResponse();
        if (loader.hasErrors()) {
            res.hasErrors = true;
            String err = "";
            Iterator iter = loader.getErrors().iterator();
            while (iter.hasNext()) {
                err = err + (String)iter.next();
                if (!iter.hasNext()) continue;
                err = err + "\n";
            }
            res.errorHeader = "Package validation errors";
            res.errorMessage = err;
        }
        return res;
    }

    protected void createPackageSnapshot(String packageName, String snapshotName, boolean replaceExisting, String comment) {
        log.info("USER:" + this.getCurrentUserName() + " CREATING PACKAGE SNAPSHOT for package: [" + packageName + "] snapshot name: [" + snapshotName);
        if (replaceExisting) {
            this.getRulesRepository().removePackageSnapshot(packageName, snapshotName);
        }
        this.getRulesRepository().createPackageSnapshot(packageName, snapshotName);
        PackageItem item = this.getRulesRepository().loadPackageSnapshot(packageName, snapshotName);
        item.updateCheckinComment(comment);
        this.getRulesRepository().save();
    }

    protected void copyOrRemoveSnapshot(String packageName, String snapshotName, boolean delete, String newSnapshotName) throws SerializationException {
        if (delete) {
            log.info("USER:" + this.getCurrentUserName() + " REMOVING SNAPSHOT for package: [" + packageName + "] snapshot: [" + snapshotName + "]");
            this.getRulesRepository().removePackageSnapshot(packageName, snapshotName);
        } else {
            if (newSnapshotName.equals("")) {
                throw new SerializationException("Need to have a new snapshot name.");
            }
            log.info("USER:" + this.getCurrentUserName() + " COPYING SNAPSHOT for package: [" + packageName + "] snapshot: [" + snapshotName + "] to [" + newSnapshotName + "]");
            this.getRulesRepository().copyPackageSnapshot(packageName, snapshotName, newSnapshotName);
        }
    }

    public BuilderResult buildPackage(String packageUUID, boolean force, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelectorName) throws SerializationException {
        PackageItem item = this.getRulesRepository().loadPackageByUUID(packageUUID);
        try {
            return this.buildPackage(item, force, buildMode, statusOperator, statusDescriptionValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelectorName);
        }
        catch (NoClassDefFoundError e) {
            throw new DetailedSerializationException("Unable to find a class that was needed when building the package  [" + e.getMessage() + "]", "Perhaps you are missing them from the model jars, or from the BRMS itself (lib directory).");
        }
        catch (UnsupportedClassVersionError e) {
            throw new DetailedSerializationException("Can not build the package. One or more of the classes that are needed were compiled with an unsupported Java version.", "For example the pojo classes were compiled with Java 1.6 and Guvnor is running on Java 1.5. [" + e.getMessage() + "]");
        }
    }

    private BuilderResult buildPackage(PackageItem item, boolean force, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String selectorConfigName) throws DetailedSerializationException {
        if (!force && item.isBinaryUpToDate()) {
            return null;
        }
        ContentPackageAssembler asm = new ContentPackageAssembler(item, true, buildMode, statusOperator, statusDescriptionValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, selectorConfigName);
        if (asm.hasErrors()) {
            BuilderResult result = new BuilderResult();
            BuilderResultHelper builderResultHelper = new BuilderResultHelper();
            result.setLines(builderResultHelper.generateBuilderResults(asm));
            return result;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)bout);
            out.writeObject(asm.getBinaryPackage());
            item.updateCompiledPackage((InputStream)new ByteArrayInputStream(bout.toByteArray()));
            out.flush();
            out.close();
            this.updateBinaryPackage(item, asm);
            this.getRulesRepository().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("An error occurred building the package [" + item.getName() + "]: " + e.getMessage());
            throw new DetailedSerializationException("An error occurred building the package.", e.getMessage());
        }
        return null;
    }

    private void updateBinaryPackage(PackageItem item, ContentPackageAssembler asm) throws SerializationException {
        item.updateBinaryUpToDate(true);
        Collection loaders = asm.getBuilder().getRootClassLoader().getClassLoaders();
        RuleBaseConfiguration conf = new RuleBaseConfiguration(loaders.toArray(new ClassLoader[loaders.size()]));
        RuleBase rb = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        rb.addPackage(asm.getBinaryPackage());
    }

    private String getCurrentUserName() {
        return this.getRulesRepository().getSession().getUserID();
    }

    protected BuilderResult buildPackage(PackageItem item, boolean force) throws DetailedSerializationException {
        return this.buildPackage(item, force, null, null, null, false, null, null, false, null);
    }

    protected String buildPackageSource(String packageUUID) throws SerializationException {
        PackageItem item = this.getRulesRepository().loadPackageByUUID(packageUUID);
        ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
        return asm.getDRL();
    }

    protected String[] listRulesInPackage(String packageName) throws SerializationException {
        PackageItem item = this.getRulesRepository().loadPackage(packageName);
        ContentPackageAssembler asm = this.createContentPackageAssembler(item, false);
        ArrayList result = new ArrayList();
        try {
            String drl = asm.getDRL();
            if (drl == null || "".equals(drl)) {
                return new String[0];
            }
            this.parseRulesToPackageList(asm, result);
            return result.toArray(new String[result.size()]);
        }
        catch (DroolsParserException e) {
            log.error("Unable to list rules in package", (Throwable)e);
            return new String[0];
        }
    }

    ContentPackageAssembler createContentPackageAssembler(PackageItem packageItem, boolean compile) {
        return new ContentPackageAssembler(packageItem, compile);
    }

    void parseRulesToPackageList(ContentPackageAssembler asm, List<String> result) throws DroolsParserException {
        int count = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(asm.getDRL(), "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String line = stringTokenizer.nextToken().trim();
            if (!line.startsWith("rule ")) continue;
            String name = ClassicDRLImporter.getRuleName((String)line);
            result.add(name);
            if (++count != 5000) continue;
            result.add("More then 5000 rules.");
            break;
        }
    }

    protected SnapshotDiffs compareSnapshots(String packageName, String firstSnapshotName, String secondSnapshotName) {
        PackageItem rightPackage;
        SnapshotDiffs diffs = new SnapshotDiffs();
        ArrayList<SnapshotDiff> list = new ArrayList<SnapshotDiff>();
        PackageItem leftPackage = this.getRulesRepository().loadPackageSnapshot(packageName, firstSnapshotName);
        if (this.isRightOlderThanLeft(leftPackage, rightPackage = this.getRulesRepository().loadPackageSnapshot(packageName, secondSnapshotName))) {
            PackageItem temp = leftPackage;
            leftPackage = rightPackage;
            rightPackage = temp;
            diffs.leftName = secondSnapshotName;
            diffs.rightName = firstSnapshotName;
        } else {
            diffs.leftName = firstSnapshotName;
            diffs.rightName = secondSnapshotName;
        }
        Iterator leftExistingIter = leftPackage.getAssets();
        while (leftExistingIter.hasNext()) {
            AssetItem left = (AssetItem)leftExistingIter.next();
            if (!this.isPackageItemDeleted(rightPackage, left)) continue;
            SnapshotDiff diff = new SnapshotDiff();
            diff.name = left.getName();
            diff.diffType = "TYPE_DELETED";
            diff.leftUuid = left.getUUID();
            list.add(diff);
        }
        Iterator rightExistingIter = rightPackage.getAssets();
        while (rightExistingIter.hasNext()) {
            SnapshotDiff diff;
            AssetItem right = (AssetItem)rightExistingIter.next();
            AssetItem left = null;
            if (right != null && leftPackage.containsAsset(right.getName())) {
                left = leftPackage.loadAsset(right.getName());
            }
            if (right == null || left == null) {
                diff = new SnapshotDiff();
                if (left == null) {
                    diff.name = right.getName();
                    diff.diffType = "TYPE_ADDED";
                    diff.rightUuid = right.getUUID();
                }
                list.add(diff);
                continue;
            }
            if (this.isAssetArchivedOrRestored(right, left)) {
                diff = new SnapshotDiff();
                diff.name = right.getName();
                diff.leftUuid = left.getUUID();
                diff.rightUuid = right.getUUID();
                diff.diffType = left.isArchived() ? "TYPE_RESTORED" : "TYPE_ARCHIVED";
                list.add(diff);
                continue;
            }
            if (!this.isAssetItemUpdated(right, left)) continue;
            diff = new SnapshotDiff();
            diff.name = right.getName();
            diff.leftUuid = left.getUUID();
            diff.rightUuid = right.getUUID();
            diff.diffType = "TYPE_UPDATED";
            list.add(diff);
        }
        diffs.diffs = list.toArray(new SnapshotDiff[list.size()]);
        return diffs;
    }

    private boolean isAssetArchivedOrRestored(AssetItem right, AssetItem left) {
        return right.isArchived() != left.isArchived();
    }

    private boolean isAssetItemUpdated(AssetItem right, AssetItem left) {
        return right.getLastModified().compareTo(left.getLastModified()) != 0;
    }

    private boolean isPackageItemDeleted(PackageItem rightPackage, AssetItem left) {
        return !rightPackage.containsAsset(left.getName());
    }

    private boolean isRightOlderThanLeft(PackageItem leftPackage, PackageItem rightPackage) {
        return leftPackage.getLastModified().compareTo(rightPackage.getLastModified()) > 0;
    }

    protected SnapshotComparisonPageResponse compareSnapshots(SnapshotComparisonPageRequest request) {
        SnapshotComparisonPageResponse response = new SnapshotComparisonPageResponse();
        long start = System.currentTimeMillis();
        SnapshotDiffs diffs = this.compareSnapshots(request.getPackageName(), request.getFirstSnapshotName(), request.getSecondSnapshotName());
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        response.setLeftSnapshotName(diffs.leftName);
        response.setRightSnapshotName(diffs.rightName);
        SnapshotComparisonPageRowBuilder snapshotComparisonPageRowBuilder = new SnapshotComparisonPageRowBuilder();
        List rowList = snapshotComparisonPageRowBuilder.createRows((PageRequest)request, diffs);
        response.setPageRowList(rowList);
        response.setStartRowIndex(request.getStartRowIndex());
        response.setTotalRowSize(diffs.diffs.length);
        response.setTotalRowSizeExact(true);
        response.setLastPage(request.getStartRowIndex() + rowList.size() == diffs.diffs.length);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Compared Snapshots ('" + request.getFirstSnapshotName() + "') and ('" + request.getSecondSnapshotName() + "') in package ('" + request.getPackageName() + "') in " + methodDuration + " ms.");
        return response;
    }
}

