/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.PackageNameType;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

public class ServiceSecurity {
    protected boolean isSecurityIsAnalystRead(Object target) {
        if (Contexts.isSessionContextActive()) {
            return Identity.instance().hasPermission(target, "analyst.readonly");
        }
        return true;
    }

    protected void checkSecurityIsPackageNameTypeAdmin(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.logInAdmin");
        }
    }

    protected void checkSecurityIsPackageDeveloper(String packageUUID) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.developer");
        }
    }

    protected void checkSecurityIsPackageDeveloper(RuleAsset asset) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(asset.metaData.packageName), "package.developer");
        }
    }

    protected void checkSecurityIsPackageReadOnly(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), "package.readonly");
        }
    }

    protected void checkSecurityIsPackageDeveloper(AssetItem item) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(item.getPackage().getUUID()), "package.developer");
        }
    }

    protected void checkSecurityIsPackageAdmin(String uuid) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(uuid), "package.logInAdmin");
        }
    }

    protected void checkSecurityIsAdmin() {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), "logInAdmin");
        }
    }

    protected void checkSecurityNameTypePackageReadOnly(PackageItem item) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(item.getName()), "package.readonly");
        }
    }

    protected void checkSecurityIsPackageDeveloperForName(String initialPackage) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(initialPackage), "package.developer");
        }
    }

    protected void checkSecurityAssetPackagePackageReadOnly(AssetItem item) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(item.getPackage().getUUID()), "package.readonly");
        }
    }
}

