/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.VersionableItem;

public class ContentAssemblyError {
    private final String errorReport;
    private final String format;
    private final String name;
    private final String uuid;
    private final boolean isPackageItem;
    private final boolean isAssetItem;

    public ContentAssemblyError(VersionableItem itemInError, String errorReport) {
        this.format = itemInError.getFormat();
        this.name = itemInError.getName();
        this.uuid = itemInError.getUUID();
        this.isPackageItem = itemInError instanceof PackageItem;
        this.isAssetItem = itemInError instanceof AssetItem;
        this.errorReport = errorReport;
    }

    public ContentAssemblyError(RuleAsset itemInError, String errorReport) {
        this.format = itemInError.metaData.format;
        this.name = itemInError.name;
        this.uuid = itemInError.uuid;
        this.isPackageItem = false;
        this.isAssetItem = true;
        this.errorReport = errorReport;
    }

    public String toString() {
        return this.getErrorReport();
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public boolean isAssetItem() {
        return this.isAssetItem;
    }

    public boolean isPackageItem() {
        return this.isPackageItem;
    }

    public String getErrorReport() {
        return this.errorReport;
    }
}

