/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.InboxIncomingPageRow;
import org.drools.guvnor.client.rpc.InboxPageRequest;
import org.drools.guvnor.client.rpc.InboxPageRow;
import org.drools.repository.UserInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboxPageRowBuilder {
    public List<InboxPageRow> createRows(InboxPageRequest pageRequest, Iterator<UserInfo.InboxEntry> iterator) {
        int skipped = 0;
        Integer pageSize = pageRequest.getPageSize();
        int startRowIndex = pageRequest.getStartRowIndex();
        ArrayList<InboxPageRow> rowList = new ArrayList<InboxPageRow>();
        while (iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            UserInfo.InboxEntry ie = iterator.next();
            if (skipped >= startRowIndex) {
                rowList.add(this.createInboxPageRow(ie, pageRequest));
            }
            ++skipped;
        }
        return rowList;
    }

    private InboxPageRow createInboxPageRow(UserInfo.InboxEntry ie, InboxPageRequest request) {
        InboxPageRow row = null;
        if (request.getInboxName().equals("incoming")) {
            InboxIncomingPageRow tr = new InboxIncomingPageRow();
            tr.setUuid(ie.assetUUID);
            tr.setFormat("brl");
            tr.setNote(ie.note);
            tr.setName(ie.note);
            tr.setTimestamp(new Date(ie.timestamp));
            tr.setFrom(ie.from);
            row = tr;
        } else {
            InboxPageRow tr = new InboxPageRow();
            tr.setUuid(ie.assetUUID);
            tr.setNote(ie.note);
            tr.setName(ie.note);
            tr.setTimestamp(new Date(ie.timestamp));
            row = tr;
        }
        return row;
    }
}

