/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;
import org.drools.ide.common.server.util.GuidedDTDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

public class GuidedDTContentHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializationException {
        TypeSafeGuidedDecisionTable model = GuidedDTXMLPersistence.getInstance().unmarshal(item.getContent());
        asset.content = model;
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        TypeSafeGuidedDecisionTable data = (TypeSafeGuidedDecisionTable)asset.content;
        if (data.getTableName() == null) {
            data.setTableName(repoAsset.getName());
        }
        repoAsset.updateContent(GuidedDTXMLPersistence.getInstance().marshal(data));
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, ContentPackageAssembler.ErrorLogger logger) throws DroolsParserException, IOException {
        String drl = this.getRawDRL(asset);
        if (drl.equals("")) {
            return;
        }
        builder.addPackageFromDrl((Reader)new StringReader(drl));
    }

    public void compile(BRMSPackageBuilder builder, RuleAsset asset, ContentPackageAssembler.ErrorLogger logger) throws DroolsParserException, IOException {
        TypeSafeGuidedDecisionTable model = (TypeSafeGuidedDecisionTable)asset.content;
        String drl = GuidedDTDRLPersistence.getInstance().marshal(model);
        if (drl.equals("")) {
            return;
        }
        builder.addPackageFromDrl((Reader)new StringReader(drl));
    }

    public void assembleDRL(BRMSPackageBuilder builder, RuleAsset asset, StringBuilder stringBuilder) {
        TypeSafeGuidedDecisionTable model = (TypeSafeGuidedDecisionTable)asset.content;
        stringBuilder.append(GuidedDTDRLPersistence.getInstance().marshal(model));
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuilder stringBuilder) {
        String drl = this.getRawDRL(asset);
        stringBuilder.append(drl);
    }

    public String getRawDRL(AssetItem asset) {
        TypeSafeGuidedDecisionTable model = GuidedDTXMLPersistence.getInstance().unmarshal(asset.getContent());
        model.setTableName(asset.getName());
        model.setParentName(this.parentNameFromCategory(asset, model.getParentName()));
        return GuidedDTDRLPersistence.getInstance().marshal(model);
    }
}

