/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetZipper {
    LinkedList<AssetItem> assets;
    PackageItem pkg;

    public AssetZipper(LinkedList<AssetItem> assets, PackageItem pkg) {
        this.assets = assets;
        this.pkg = pkg;
    }

    public InputStream zipAssets() {
        AssetItem zipFileElement = null;
        BufferedInputStream inputZip = null;
        Iterator it = this.assets.iterator();
        byte[] data = new byte[1000];
        Object modelStream = null;
        int count = 0;
        try {
            if (this.assets.size() > 1) {
                ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
                ZipOutputStream outputZip = new ZipOutputStream(outputBytes);
                while (it.hasNext()) {
                    zipFileElement = (AssetItem)it.next();
                    inputZip = new BufferedInputStream(zipFileElement.getBinaryContentAttachment());
                    outputZip.putNextEntry(new ZipEntry(zipFileElement.getName() + "." + zipFileElement.getFormat()));
                    while ((count = inputZip.read(data, 0, 1000)) != -1) {
                        outputZip.write(data, 0, count);
                    }
                    outputZip.flush();
                    inputZip.close();
                }
                outputZip.close();
                return new ByteArrayInputStream(outputBytes.toByteArray());
            }
            return ((AssetItem)it.next()).getBinaryContentAttachment();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

