/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.drools.guvnor.server.jaxrs.Resource;
import org.drools.guvnor.server.jaxrs.Translator;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemPageResult;
import org.jboss.seam.annotations.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="CategoryResource")
@Path(value="/categories")
public class CategoryResource
extends Resource {
    static final String Encoding = "UTF-8";
    final int pageSize = 10;

    @GET
    @Path(value="{categoryName}")
    @Produces(value={"application/atom+xml"})
    public Feed getAssetsAsAtom(@PathParam(value="categoryName") String encoded) {
        Factory factory = Abdera.getNewFactory();
        Feed f = factory.getAbdera().newFeed();
        try {
            String decoded = URLDecoder.decode(encoded, Encoding);
            UriBuilder builder = this.uriInfo.getAbsolutePathBuilder();
            f.setTitle(encoded);
            AssetItemPageResult result = this.repository.findAssetsByCategory(decoded, 0, 10);
            List assets = result.assets;
            for (AssetItem item : assets) {
                Entry e = Translator.ToAssetEntryAbdera((AssetItem)item, (UriInfo)this.uriInfo);
                f.addEntry(e);
            }
            if (result.hasNext) {
                Link l = factory.newLink();
                l.setRel("next-page");
                l.setHref(builder.path("/" + encoded + "/page/1").build(new Object[0]).toString());
                f.addLink(l);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return f;
    }

    @GET
    @Path(value="{categoryName}")
    @Produces(value={"application/json", "application/xml"})
    public Collection<Asset> getAssetsAsJAXB(@PathParam(value="categoryName") String encoded) {
        ArrayList<Asset> ret = Collections.EMPTY_LIST;
        try {
            String decoded = URLDecoder.decode(encoded, Encoding);
            AssetItemPageResult result = this.repository.findAssetsByCategory(decoded, 0, 10);
            List assets = result.assets;
            if (assets.size() > 0) {
                ret = new ArrayList<Asset>();
                for (AssetItem item : assets) {
                    ret.add(Translator.ToAsset((AssetItem)item, (UriInfo)this.uriInfo));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @GET
    @Path(value="{categoryName}/page/{page}")
    @Produces(value={"application/json", "application/xml"})
    public Collection<Asset> getAssetsAsJAXBIndex(@PathParam(value="categoryName") String encoded, @PathParam(value="page") String page) {
        ArrayList<Asset> ret = Collections.EMPTY_LIST;
        try {
            String decoded = URLDecoder.decode(encoded, Encoding);
            int p = new Integer(page);
            AssetItemPageResult result = this.repository.findAssetsByCategory(decoded, p, 10);
            List assets = result.assets;
            if (assets.size() > 0) {
                ret = new ArrayList<Asset>();
                for (AssetItem item : assets) {
                    ret.add(Translator.ToAsset((AssetItem)item, (UriInfo)this.uriInfo));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }
}

