/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.standalonededitor;

import com.google.gwt.user.client.rpc.SerializationException;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.standalonededitor.RuleAssetProvider;

public class NewRuleAssetProvider
implements RuleAssetProvider {
    private String packageName;
    private String categoryName;
    private String assetName;
    private String assetFormat;

    public NewRuleAssetProvider(String packageName, String categoryName, String assetName, String assetFormat) {
        this.packageName = packageName;
        this.categoryName = categoryName;
        this.assetName = assetName;
        this.assetFormat = assetFormat != null ? assetFormat : "brl";
    }

    public RuleAsset[] getRuleAssets() throws DetailedSerializationException {
        try {
            String ruleUUID = this.getService().createNewRule(this.assetName, "created by standalone editor", this.categoryName, this.packageName, this.assetFormat);
            RuleAsset newRule = this.getAssetService().loadRuleAsset(ruleUUID);
            return new RuleAsset[]{newRule};
        }
        catch (SerializationException ex) {
            throw new DetailedSerializationException("Error creating rule asset", ex.getMessage());
        }
    }

    private ServiceImplementation getService() {
        return RepositoryServiceServlet.getService();
    }

    private RepositoryAssetService getAssetService() {
        return RepositoryServiceServlet.getAssetService();
    }
}

