/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ClosableLabel;
import org.drools.guvnor.client.explorer.ExplorerViewCenterPanel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.ModuleEditorWrapper;
import org.drools.guvnor.client.util.ScrollTabLayoutPanel;
import org.drools.guvnor.client.util.TabbedPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerViewCenterPanel
extends Composite
implements TabbedPanel {
    private final ScrollTabLayoutPanel tabLayoutPanel;
    private PanelMap openedTabs = new PanelMap(this, null);
    private Map<String, ModuleEditorWrapper> openedModuleEditors = new HashMap();
    private ClientFactory clientFactory;
    private final EventBus eventBus;

    public ExplorerViewCenterPanel(ClientFactory clientFactory, EventBus eventBus) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.tabLayoutPanel = new ScrollTabLayoutPanel();
        this.addBeforeSelectionHandler();
        this.initWidget((Widget)this.createLayout());
    }

    private DockLayoutPanel createLayout() {
        DockLayoutPanel layoutPanel = new DockLayoutPanel(Style.Unit.EM);
        layoutPanel.addSouth((Widget)this.createBottomPanel(), 2.0);
        layoutPanel.add((Widget)this.tabLayoutPanel);
        return layoutPanel;
    }

    private HorizontalPanel createBottomPanel() {
        HorizontalPanel bottomPanel = new HorizontalPanel();
        bottomPanel.setWidth("100%");
        bottomPanel.setStyleName("bottom-panel");
        bottomPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        bottomPanel.add((Widget)this.createCloseAllButton());
        return bottomPanel;
    }

    private Button createCloseAllButton() {
        Constants constants = (Constants)GWT.create(Constants.class);
        Button button = new Button(constants.CloseAllItems());
        button.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return button;
    }

    private void addBeforeSelectionHandler() {
        this.tabLayoutPanel.addBeforeSelectionHandler((BeforeSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean contains(Place key) {
        return this.openedTabs.contains(key);
    }

    public void show(Place key) {
        if (this.openedTabs.contains(key)) {
            LoadingPopup.close();
            this.tabLayoutPanel.selectTab((Widget)this.openedTabs.get(key));
        }
    }

    public void addTab(String tabname, IsWidget widget, Place place) {
        ScrollPanel localTP = new ScrollPanel();
        localTP.add(widget);
        this.tabLayoutPanel.add((Widget)localTP, this.newClosableLabel(tabname, place));
        this.tabLayoutPanel.selectTab((Widget)localTP);
        if (widget instanceof ModuleEditorWrapper) {
            this.getOpenedModuleEditors().put(tabname, (ModuleEditorWrapper)widget);
        }
        this.openedTabs.put(place, (Panel)localTP);
    }

    private Widget newClosableLabel(String title, Place place) {
        ClosableLabel closableLabel = new ClosableLabel(title);
        closableLabel.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        return closableLabel;
    }

    public void close(Place key) {
        int widgetIndex = this.openedTabs.getIndex(key);
        Place nextPlace = this.getPlace(widgetIndex);
        this.tabLayoutPanel.remove((Widget)this.openedTabs.get(key));
        this.openedTabs.remove(key);
        if (nextPlace != null) {
            this.goTo(nextPlace);
        } else {
            this.goTo(Place.NOWHERE);
        }
    }

    private Place getPlace(int widgetIndex) {
        if (this.isOnlyOneTabLeft()) {
            return Place.NOWHERE;
        }
        if (this.isSelectedTabIndex(widgetIndex)) {
            return this.getNeighbour(widgetIndex);
        }
        return null;
    }

    private void goTo(Place place) {
        this.clientFactory.getPlaceController().goTo(place);
    }

    private Place getNeighbour(int widgetIndex) {
        if (this.isLeftMost(widgetIndex)) {
            return this.getNextPlace();
        }
        return this.getPreviousPlace();
    }

    private boolean isLeftMost(int widgetIndex) {
        return widgetIndex == 0;
    }

    private boolean isSelectedTabIndex(int widgetIndex) {
        return this.tabLayoutPanel.getSelectedIndex() == widgetIndex;
    }

    private Place getPreviousPlace() {
        if (this.tabLayoutPanel.getSelectedIndex() > 0) {
            return this.openedTabs.getKey(this.tabLayoutPanel.getSelectedIndex() - 1);
        }
        return null;
    }

    private Place getNextPlace() {
        return this.openedTabs.getKey(this.tabLayoutPanel.getSelectedIndex() + 1);
    }

    private boolean isOnlyOneTabLeft() {
        return this.tabLayoutPanel.getWidgetCount() == 1;
    }

    public Map<String, ModuleEditorWrapper> getOpenedModuleEditors() {
        return this.openedModuleEditors;
    }

    static /* synthetic */ EventBus access$100(ExplorerViewCenterPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ ScrollTabLayoutPanel access$200(ExplorerViewCenterPanel x0) {
        return x0.tabLayoutPanel;
    }

    static /* synthetic */ PanelMap access$300(ExplorerViewCenterPanel x0) {
        return x0.openedTabs;
    }

    static /* synthetic */ ClientFactory access$400(ExplorerViewCenterPanel x0) {
        return x0.clientFactory;
    }
}

