/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.admin.ArchivedAssetManager;
import org.drools.guvnor.client.admin.BackupManager;
import org.drools.guvnor.client.admin.CategoryManager;
import org.drools.guvnor.client.admin.EventLogPresenter;
import org.drools.guvnor.client.admin.EventLogViewImpl;
import org.drools.guvnor.client.admin.PermissionViewer;
import org.drools.guvnor.client.admin.RepoConfigManager;
import org.drools.guvnor.client.admin.RuleVerifierManager;
import org.drools.guvnor.client.admin.StateManager;
import org.drools.guvnor.client.admin.WorkspaceManager;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.util.Activity;

public class ManagerActivity
extends Activity {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private final int id;
    private final ClientFactory clientFactory;

    public ManagerActivity(int id, ClientFactory clientFactory) {
        this.id = id;
        this.clientFactory = clientFactory;
    }

    public void start(AcceptItem tabbedPanel, EventBus eventBus) {
        this.openAdministrationSelection(tabbedPanel, this.id, eventBus);
    }

    public void openAdministrationSelection(AcceptItem tabbedPanel, int id, EventBus eventBus) {
        switch (id) {
            case 0: {
                tabbedPanel.add(this.constants.CategoryManager(), (IsWidget)new CategoryManager());
                break;
            }
            case 1: {
                tabbedPanel.add(this.constants.ArchivedManager(), (IsWidget)new ArchivedAssetManager(this.clientFactory));
                break;
            }
            case 2: {
                tabbedPanel.add(this.constants.StateManager(), (IsWidget)new StateManager());
                break;
            }
            case 3: {
                tabbedPanel.add(this.constants.ImportExport(), (IsWidget)new BackupManager());
                break;
            }
            case 4: {
                EventLogViewImpl eventLogView = new EventLogViewImpl();
                RepositoryServiceAsync repositoryService = RepositoryServiceFactory.getService();
                new EventLogPresenter(repositoryService, (EventLogPresenter.EventLogView)eventLogView);
                tabbedPanel.add(this.constants.EventLog(), (IsWidget)eventLogView);
                break;
            }
            case 5: {
                tabbedPanel.add(this.constants.UserPermissionMappings(), (IsWidget)new PermissionViewer());
                break;
            }
            case 6: {
                Frame aboutInfoFrame = new Frame("../AboutInfo.html");
                FormStylePopup aboutPop = new FormStylePopup();
                aboutPop.setWidth("600px");
                aboutPop.setTitle(this.constants.About());
                String hhurl = GWT.getModuleBaseURL() + "webdav";
                aboutPop.addAttribute(this.constants.WebDAVURL() + ":", (Widget)new SmallLabel("<b>" + hhurl + "</b>"));
                aboutPop.addAttribute(this.constants.Version() + ":", (Widget)aboutInfoFrame);
                aboutPop.show();
                aboutPop.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 7: {
                tabbedPanel.add(this.constants.RulesVerificationManager(), (IsWidget)new RuleVerifierManager());
                break;
            }
            case 8: {
                tabbedPanel.add(this.constants.RepositoryConfig(), (IsWidget)new RepoConfigManager());
                break;
            }
            case 9: {
                tabbedPanel.add(this.constants.Workspaces(), (IsWidget)new WorkspaceManager());
            }
        }
    }
}

