/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.modules;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.modules.ChangeModuleHierarchyEvent;
import org.drools.guvnor.client.explorer.navigation.modules.CollapseAllEvent;
import org.drools.guvnor.client.explorer.navigation.modules.ExpandAllEvent;
import org.drools.guvnor.client.explorer.navigation.modules.GlobalAreaTreeItem;
import org.drools.guvnor.client.explorer.navigation.modules.ModulesTreeItem;
import org.drools.guvnor.client.explorer.navigation.modules.ModulesTreeView;
import org.drools.guvnor.client.explorer.navigation.modules.PackageFlatView;
import org.drools.guvnor.client.explorer.navigation.modules.PackageHierarchicalView;
import org.drools.guvnor.client.explorer.navigation.modules.PackageView;

public class ModulesTree
implements ModulesTreeView.Presenter {
    private ModulesTreeView view;
    private ClientFactory clientFactory;
    private final EventBus eventBus;
    private String perspectiveTypes;

    public ModulesTree(ClientFactory clientFactory, EventBus eventBus, String perspectiveTypes) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.perspectiveTypes = perspectiveTypes;
        this.view = clientFactory.getNavigationViewFactory().getModulesTreeView();
        this.view.setPresenter((ModulesTreeView.Presenter)this);
        this.addRootPanels();
    }

    private void addRootPanels() {
        this.view.setGlobalAreaTreeItem(new GlobalAreaTreeItem(this.clientFactory));
        this.view.setModulesTreeItem(new ModulesTreeItem(this.clientFactory, this.eventBus, this.perspectiveTypes));
        if (UserCapabilities.INSTANCE.hasCapability(new Capability[]{Capability.SHOW_CREATE_NEW_ASSET})) {
            this.view.setNewAssetMenu(this.clientFactory.getNavigationViewFactory().getModulesNewAssetMenu(this.perspectiveTypes));
        }
    }

    public void setFlatView() {
        ChangeModuleHierarchyEvent event = new ChangeModuleHierarchyEvent((PackageView)new PackageFlatView());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    public void setHierarchyView() {
        ChangeModuleHierarchyEvent event = new ChangeModuleHierarchyEvent((PackageView)new PackageHierarchicalView());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    public void expandAll() {
        ExpandAllEvent event = new ExpandAllEvent();
        this.eventBus.fireEvent((GwtEvent)event);
    }

    public void collapseAll() {
        CollapseAllEvent event = new CollapseAllEvent();
        this.eventBus.fireEvent((GwtEvent)event);
    }
}

