/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.MultiAssetPlace;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.CheckinPopup;
import org.drools.guvnor.client.ruleeditor.DefaultMultiViewEditorMenuBarCreator;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.MultiViewEditorMenuBarCreator;
import org.drools.guvnor.client.ruleeditor.MultiViewRow;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.util.LazyStackPanel;
import org.drools.guvnor.client.util.LoadContentCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class MultiViewEditor
extends GuvnorEditor {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private final ClientFactory clientFactory;
    private VerticalPanel viewsPanel = new VerticalPanel();
    private Command closeCommand;
    private final Set<MultiViewRow> rows = new HashSet();
    private Map<String, RuleViewer> ruleViews = new HashMap();
    private ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider;
    private Map<String, RuleAsset> assets = new HashMap();
    private MultiViewEditorMenuBarCreator menuBarCreator;
    private final EventBus eventBus;

    public MultiViewEditor(MultiViewRow[] rows, ClientFactory clientFactory, EventBus eventBus) {
        this(rows, clientFactory, eventBus, null);
    }

    public MultiViewEditor(MultiViewRow[] rows, ClientFactory clientFactory, EventBus eventBus, ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider) {
        this(Arrays.asList(rows), clientFactory, eventBus, individualActionToolbarButtonsConfigurationProvider);
    }

    public MultiViewEditor(List<MultiViewRow> rows, ClientFactory clientFactory, EventBus eventBus, ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider) {
        this.rows.addAll(rows);
        this.individualActionToolbarButtonsConfigurationProvider = individualActionToolbarButtonsConfigurationProvider;
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.init();
    }

    public MultiViewEditor(RuleAsset[] assets, ClientFactory clientFactory, EventBus eventBus, ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider) {
        this(assets, clientFactory, eventBus, individualActionToolbarButtonsConfigurationProvider, null);
    }

    public MultiViewEditor(RuleAsset[] assets, ClientFactory clientFactory, EventBus eventBus, ActionToolbarButtonsConfigurationProvider individualActionToolbarButtonsConfigurationProvider, MultiViewEditorMenuBarCreator menuBarCreator) {
        this.rows.addAll(MultiViewEditor.createRows((RuleAsset[])assets));
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.individualActionToolbarButtonsConfigurationProvider = individualActionToolbarButtonsConfigurationProvider;
        this.menuBarCreator = menuBarCreator;
        this.addAssets(assets);
        this.init();
    }

    private void addAssets(RuleAsset[] assets) {
        for (RuleAsset ruleAsset : assets) {
            this.assets.put(ruleAsset.getUuid(), ruleAsset);
        }
    }

    private static List<MultiViewRow> createRows(RuleAsset[] assets) {
        ArrayList<MultiViewRow> rows = new ArrayList<MultiViewRow>();
        for (RuleAsset ruleAsset : assets) {
            MultiViewRow row = new MultiViewRow(ruleAsset.getUuid(), ruleAsset.getName(), "brl");
            rows.add(row);
        }
        return rows;
    }

    private void init() {
        VerticalPanel rootPanel = new VerticalPanel();
        rootPanel.setWidth("100%");
        rootPanel.add((Widget)this.createToolbar());
        this.viewsPanel.setWidth("100%");
        rootPanel.add((Widget)this.viewsPanel);
        this.doViews();
        this.initWidget((Widget)rootPanel);
    }

    private MenuBar createToolbar() {
        if (this.menuBarCreator == null) {
            this.menuBarCreator = new DefaultMultiViewEditorMenuBarCreator();
        }
        return this.menuBarCreator.createMenuBar(this);
    }

    private void doViews() {
        this.viewsPanel.clear();
        this.ruleViews.clear();
        LazyStackPanel panel = new LazyStackPanel();
        int rowNumber = 1;
        for (MultiViewRow row : this.rows) {
            panel.add(row.getName(), (LoadContentCommand)new /* Unavailable Anonymous Inner Class!! */, rowNumber == 1);
            ++rowNumber;
        }
        this.viewsPanel.add((Widget)panel);
    }

    private void addRuleViewInToSimplePanel(MultiViewRow row, SimplePanel content, RuleAsset asset) {
        SuggestionCompletionCache.getInstance().doAction(asset.getMetaData().getPackageName(), (Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void checkin(boolean closeAfter) {
        CheckinPopup pop = new CheckinPopup(this.constants.CheckInChanges());
        pop.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    public void close() {
        this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent((Place)new MultiAssetPlace((Collection)this.rows)));
        if (this.closeCommand != null) {
            this.closeCommand.execute();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void makeDirty() {
    }

    public void resetDirty() {
    }

    public void setCloseCommand(Command command) {
        this.closeCommand = command;
    }

    static /* synthetic */ Map access$000(MultiViewEditor x0) {
        return x0.assets;
    }

    static /* synthetic */ void access$100(MultiViewEditor x0, MultiViewRow x1, SimplePanel x2, RuleAsset x3) {
        x0.addRuleViewInToSimplePanel(x1, x2, x3);
    }

    static /* synthetic */ Map access$200(MultiViewEditor x0) {
        return x0.ruleViews;
    }

    static /* synthetic */ Set access$300(MultiViewEditor x0) {
        return x0.rows;
    }

    static /* synthetic */ void access$400(MultiViewEditor x0) {
        x0.doViews();
    }

    static /* synthetic */ ClientFactory access$500(MultiViewEditor x0) {
        return x0.clientFactory;
    }

    static /* synthetic */ EventBus access$600(MultiViewEditor x0) {
        return x0.eventBus;
    }

    static /* synthetic */ ActionToolbarButtonsConfigurationProvider access$700(MultiViewEditor x0) {
        return x0.individualActionToolbarButtonsConfigurationProvider;
    }
}

