/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.wizards.assets.decisiontable;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.factmodel.ModelNameHelper;
import org.drools.guvnor.client.widgets.wizards.assets.NewAssetWizardContext;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.AbstractGuidedDecisionTableWizardPage;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.ActionSetFieldsPageView;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.ActionSetFieldsPageViewImpl;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.AvailableField;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.Validator;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.events.ActionSetFieldsDefinedEvent;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.events.DuplicatePatternsEvent;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.events.PatternRemovedEvent;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class ActionSetFieldsPage
extends AbstractGuidedDecisionTableWizardPage
implements ActionSetFieldsPageView.Presenter,
PatternRemovedEvent.Handler,
DuplicatePatternsEvent.Handler,
ActionSetFieldsDefinedEvent.Handler {
    private final ModelNameHelper modelNameHelper = new ModelNameHelper();
    private ActionSetFieldsPageView view;
    private Map<Pattern52, List<ActionSetFieldCol52>> patternToActionsMap = new IdentityHashMap();

    public ActionSetFieldsPage(NewAssetWizardContext context, GuidedDecisionTable52 dtable, EventBus eventBus, Validator validator) {
        super(context, dtable, eventBus, validator);
        this.getValidator().setPatternToActionSetFieldsMap(this.patternToActionsMap);
        this.view = new ActionSetFieldsPageViewImpl(this.getValidator());
        eventBus.addHandler(PatternRemovedEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DuplicatePatternsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(ActionSetFieldsDefinedEvent.TYPE, (EventHandler)this);
    }

    public void onPatternRemoved(PatternRemovedEvent event) {
        this.patternToActionsMap.remove(event.getPattern());
    }

    public String getTitle() {
        return constants.DecisionTableWizardActionSetFields();
    }

    public void initialise() {
        if (this.sce == null) {
            return;
        }
        for (ActionCol52 a : this.dtable.getActionCols()) {
            if (!(a instanceof ActionSetFieldCol52)) continue;
            ActionSetFieldCol52 asf = (ActionSetFieldCol52)a;
            Pattern52 p = this.dtable.getConditionPattern(asf.getBoundName());
            if (!this.patternToActionsMap.containsKey(p)) {
                this.patternToActionsMap.put(p, new ArrayList());
            }
            List actions = (List)this.patternToActionsMap.get(p);
            actions.add(asf);
        }
        this.view.setPresenter((ActionSetFieldsPageView.Presenter)this);
        this.content.setWidget((IsWidget)this.view);
    }

    public void prepareView() {
        ArrayList<Pattern52> availablePatterns = new ArrayList<Pattern52>();
        for (Pattern52 p : this.dtable.getConditionPatterns()) {
            if (p.getBoundName() == null || p.getBoundName().equals("")) continue;
            availablePatterns.add(p);
        }
        this.view.setAvailablePatterns(availablePatterns);
    }

    public boolean isComplete() {
        boolean areActionSetFieldsDefined = true;
        block0: for (List actions : this.patternToActionsMap.values()) {
            for (ActionSetFieldCol52 a : actions) {
                if (this.getValidator().isActionValid((ActionCol52)a)) continue;
                areActionSetFieldsDefined = false;
                continue block0;
            }
        }
        ActionSetFieldsDefinedEvent event = new ActionSetFieldsDefinedEvent(areActionSetFieldsDefined);
        this.eventBus.fireEvent((GwtEvent)event);
        return areActionSetFieldsDefined;
    }

    public void onDuplicatePatterns(DuplicatePatternsEvent event) {
        this.view.setArePatternBindingsUnique(event.getArePatternBindingsUnique());
    }

    public void onActionSetFieldsDefined(ActionSetFieldsDefinedEvent event) {
        this.view.setAreActionSetFieldsDefined(event.getAreActionSetFieldsDefined());
    }

    public void selectPattern(Pattern52 pattern) {
        String type = pattern.getFactType();
        String[] fieldNames = this.sce.getFieldCompletions(type);
        ArrayList<AvailableField> availableFields = new ArrayList<AvailableField>();
        for (String fieldName : fieldNames) {
            String fieldType = this.modelNameHelper.getUserFriendlyTypeName(this.sce.getFieldType(type, fieldName));
            AvailableField field = new AvailableField(fieldName, fieldType, 1);
            availableFields.add(field);
        }
        this.view.setAvailableFields(availableFields);
        ArrayList actionsForPattern = (ArrayList)this.patternToActionsMap.get(pattern);
        if (actionsForPattern == null) {
            actionsForPattern = new ArrayList();
            this.patternToActionsMap.put(pattern, actionsForPattern);
        }
        this.view.setChosenFields(actionsForPattern);
    }

    public void makeResult(GuidedDecisionTable52 dtable) {
        for (List actions : this.patternToActionsMap.values()) {
            for (ActionSetFieldCol52 af : actions) {
                dtable.getActionCols().add(af);
            }
        }
    }
}

