/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.wizards.assets.decisiontable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.ActionInsertFactFieldsPattern;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator {
    private List<Pattern52> patternsConditions;
    private List<Pattern52> patternsActions;
    private Map<Pattern52, List<ActionSetFieldCol52>> patternToActionSetFieldsMap;
    private Map<ActionInsertFactFieldsPattern, List<ActionInsertFactCol52>> patternToActionInsertFactFieldsMap;

    Validator(List<Pattern52> patterns) {
        this.patternsConditions = patterns;
        this.patternsActions = new ArrayList();
    }

    void addActionPattern(Pattern52 pattern) {
        this.patternsActions.add(pattern);
    }

    void removeActionPattern(Pattern52 pattern) {
        this.patternsActions.remove(pattern);
    }

    public boolean arePatternBindingsUnique() {
        List<Pattern52> ps;
        String binding;
        boolean hasUniqueBindings = true;
        HashMap bindings = new HashMap();
        for (Pattern52 p : this.patternsConditions) {
            binding = p.getBoundName();
            if (binding == null || binding.equals("")) continue;
            ps = (ArrayList<Pattern52>)bindings.get(binding);
            if (ps == null) {
                ps = new ArrayList<Pattern52>();
                bindings.put(binding, ps);
            }
            ps.add(p);
        }
        for (Pattern52 p : this.patternsActions) {
            binding = p.getBoundName();
            if (binding == null || binding.equals("")) continue;
            ps = (List)bindings.get(binding);
            if (ps == null) {
                ps = new ArrayList();
                bindings.put(binding, ps);
            }
            ps.add(p);
        }
        for (List pws : bindings.values()) {
            if (pws.size() <= 1) continue;
            hasUniqueBindings = false;
            break;
        }
        return hasUniqueBindings;
    }

    public boolean isPatternBindingUnique(Pattern52 pattern) {
        String binding = pattern.getBoundName();
        if (binding == null || binding.equals("")) {
            return true;
        }
        for (Pattern52 p : this.patternsConditions) {
            if (p == pattern || p.getBoundName() == null || !p.getBoundName().equals(binding)) continue;
            return false;
        }
        for (Pattern52 p : this.patternsActions) {
            if (p == pattern || p.getBoundName() == null || !p.getBoundName().equals(binding)) continue;
            return false;
        }
        return true;
    }

    public boolean isPatternValid(Pattern52 p) {
        return p.getBoundName() != null && !p.getBoundName().equals("");
    }

    public boolean isConditionValid(ConditionCol52 c) {
        return this.isConditionHeaderValid(c) && this.isConditionOperatorValid(c);
    }

    public boolean isConditionHeaderValid(ConditionCol52 c) {
        return c.getHeader() != null && !c.getHeader().equals("");
    }

    public boolean isConditionOperatorValid(ConditionCol52 c) {
        if (c.getConstraintValueType() == 5) {
            return true;
        }
        return c.getOperator() != null && !c.getOperator().equals("");
    }

    public boolean isActionValid(ActionCol52 c) {
        return this.isActionHeaderValid(c);
    }

    public boolean isActionHeaderValid(ActionCol52 a) {
        return a.getHeader() != null && !a.getHeader().equals("");
    }

    public void setPatternToActionSetFieldsMap(Map<Pattern52, List<ActionSetFieldCol52>> patternToActionSetFieldsMap) {
        this.patternToActionSetFieldsMap = patternToActionSetFieldsMap;
    }

    public boolean arePatternActionSetFieldsValid(Pattern52 p) {
        if (this.patternToActionSetFieldsMap == null) {
            return true;
        }
        List actions = (List)this.patternToActionSetFieldsMap.get(p);
        if (actions == null) {
            return true;
        }
        for (ActionSetFieldCol52 a : actions) {
            if (this.isActionValid((ActionCol52)a)) continue;
            return false;
        }
        return true;
    }

    public void setPatternToActionInsertFactFieldsMap(Map<ActionInsertFactFieldsPattern, List<ActionInsertFactCol52>> patternToActionInsertFactFieldsMap) {
        this.patternToActionInsertFactFieldsMap = patternToActionInsertFactFieldsMap;
    }

    public boolean arePatternActionInsertFactFieldsValid(Pattern52 p) {
        if (this.patternToActionInsertFactFieldsMap == null) {
            return true;
        }
        List actions = (List)this.patternToActionInsertFactFieldsMap.get(p);
        if (actions == null) {
            return true;
        }
        for (ActionInsertFactCol52 a : actions) {
            if (this.isActionValid((ActionCol52)a)) continue;
            return false;
        }
        return true;
    }
}

