/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.wizards.assets.decisiontable.cells;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import org.drools.guvnor.client.resources.WizardResources;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.Validator;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.cells.ConditionCell;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionCell
extends AbstractCell<ConditionCol52> {
    private Validator validator;
    private static final ConditionCellTemplate TEMPLATE = (ConditionCellTemplate)GWT.create(ConditionCellTemplate.class);

    public ConditionCell(Validator validator) {
        super(new String[0]);
        this.validator = validator;
    }

    public void render(Cell.Context context, ConditionCol52 value, SafeHtmlBuilder sb) {
        StringBuilder b = new StringBuilder();
        switch (value.getConstraintValueType()) {
            case 1: {
                this.makeLiteral(b, value);
                break;
            }
            case 3: {
                this.makeFormula(b, value);
                break;
            }
            case 5: {
                this.makePredicate(b, value);
            }
        }
        sb.append(TEMPLATE.text(this.getCssStyleName(value), b.toString()));
    }

    private void makeLiteral(StringBuilder sb, ConditionCol52 condition) {
        this.appendHeader(sb, condition);
        sb.append(condition.getFactField());
    }

    private void makeFormula(StringBuilder sb, ConditionCol52 condition) {
        this.appendHeader(sb, condition);
        sb.append(condition.getFactField());
    }

    private void makePredicate(StringBuilder sb, ConditionCol52 condition) {
        this.appendHeader(sb, condition);
        sb.append(condition.getFactField());
    }

    private void appendHeader(StringBuilder sb, ConditionCol52 condition) {
        if (this.validator.isConditionHeaderValid(condition)) {
            sb.append("[");
            sb.append(condition.getHeader());
            sb.append("] ");
        }
    }

    private String getCssStyleName(ConditionCol52 c) {
        if (!this.validator.isConditionValid(c)) {
            return WizardResources.INSTANCE.style().wizardDTableValidationError();
        }
        return "";
    }
}

