/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;
import org.drools.util.ChainedProperties;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BRMSPackageBuilder
extends PackageBuilder {
    private List<DSLTokenizedMappingFile> dslFiles;
    private DefaultExpander expander;

    BRMSPackageBuilder(PackageBuilderConfiguration config) {
        super(config);
    }

    public BRMSPackageBuilder() {
        super(new PackageBuilderConfiguration());
    }

    public BRMSPackageBuilder(Properties properties, ClassLoader classLoader) {
        this(BRMSPackageBuilder.getPackageBuilderConfiguration((Properties)properties, (ClassLoader)classLoader));
    }

    public BRMSPackageBuilder(PackageItem packageItem) {
        this(BRMSPackageBuilder.getPackageBuilderConfiguration((Properties)BRMSPackageBuilder.getProperties((AssetItemIterator)packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"properties", "conf"}), (String)packageItem.getName()), (ClassLoader)new ClassLoaderBuilder(packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"jar"})).buildClassLoader()));
    }

    public void clearErrors() {
        super.resetErrors();
    }

    public void setDSLFiles(List<DSLTokenizedMappingFile> files) {
        this.dslFiles = files;
    }

    public List<DSLTokenizedMappingFile> getDSLMappingFiles() {
        return Collections.unmodifiableList(this.dslFiles);
    }

    public static Properties getProperties(AssetItemIterator assetItemIterator, String packageName) {
        Properties properties = new Properties();
        properties.setProperty("drools.dialect.java.compiler", BRMSPackageBuilder.getChainedProperties().getProperty("drools.dialect.java.compiler", "ECLIPSE"));
        try {
            Properties properties1 = BRMSPackageBuilder.loadConfigurationProperties((AssetItemIterator)assetItemIterator);
            properties1.setProperty("drools.defaultPackageName", packageName);
            properties.putAll((Map<?, ?>)properties1);
        }
        catch (IOException e) {
            throw new RulesRepositoryException("Unable to load configuration properties for package.", (Throwable)e);
        }
        return properties;
    }

    private static ChainedProperties getChainedProperties() {
        return new ChainedProperties("packagebuilder.conf", BRMSPackageBuilder.class.getClassLoader(), false);
    }

    private static Properties loadConfigurationProperties(AssetItemIterator assetItemIterator) throws IOException {
        Properties bigHappyProperties = new Properties();
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = assetItemIterator.next();
            assetItem.getContent();
            Properties properties = new Properties();
            properties.load(assetItem.getBinaryContentAttachment());
            bigHappyProperties.putAll((Map<?, ?>)properties);
        }
        return bigHappyProperties;
    }

    private static PackageBuilderConfiguration getPackageBuilderConfiguration(Properties properties, ClassLoader classLoader) {
        PackageBuilderConfiguration packageBuilderConfiguration = new PackageBuilderConfiguration(properties, new ClassLoader[]{classLoader});
        packageBuilderConfiguration.setAllowMultipleNamespaces(false);
        packageBuilderConfiguration.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        packageBuilderConfiguration.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        return packageBuilderConfiguration;
    }

    public boolean hasDSL() {
        return this.dslFiles != null && this.dslFiles.size() > 0;
    }

    public DefaultExpander getDSLExpander() {
        if (this.expander == null) {
            this.expander = new DefaultExpander();
            for (DSLTokenizedMappingFile file : this.dslFiles) {
                this.expander.addDSLMapping(file.getMapping());
            }
        }
        return this.expander;
    }
}

