/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.StatePageRow;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.drools.repository.AssetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatePageRowBuilder
implements PageRowBuilder<PageRequest, Iterator<AssetItem>> {
    private PageRequest pageRequest;
    private Iterator<AssetItem> iterator;

    public List<StatePageRow> build() {
        this.validate();
        ArrayList<StatePageRow> rowList = new ArrayList<StatePageRow>();
        while (this.iterator.hasNext()) {
            AssetItem assetItem = (AssetItem)this.iterator.next();
            rowList.add(this.makeStatePageRow(assetItem));
        }
        return rowList;
    }

    private StatePageRow makeStatePageRow(AssetItem assetItem) {
        StatePageRow row = new StatePageRow();
        row.setUuid(assetItem.getUUID());
        row.setFormat(assetItem.getFormat());
        row.setName(assetItem.getName());
        row.setDescription(assetItem.getDescription());
        row.setAbbreviatedDescription(StringUtils.abbreviate((String)assetItem.getDescription(), (int)80));
        row.setLastModified(assetItem.getLastModified().getTime());
        row.setStateName(assetItem.getState().getName());
        row.setPackageName(assetItem.getPackageName());
        return row;
    }

    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public StatePageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public StatePageRowBuilder withContent(Iterator<AssetItem> iterator) {
        this.iterator = iterator;
        return this;
    }
}

