/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.verification;

import java.util.Iterator;
import org.drools.guvnor.server.builder.AssetValidationIterator;
import org.drools.guvnor.server.verification.VerifierRunner;
import org.drools.repository.AssetItem;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.ScopesAgendaFilter;

public class AssetVerifier
extends VerifierRunner {
    private final AssetItem assetItem;

    public AssetVerifier(Verifier verifier, AssetItem assetItem) {
        super(verifier, assetItem.getPackage());
        this.assetItem = assetItem;
    }

    protected ScopesAgendaFilter getScopesAgendaFilter() {
        if (this.isAssetDecisionTable(this.assetItem)) {
            return new ScopesAgendaFilter(true, "decision-table");
        }
        return new ScopesAgendaFilter(true, "single-rule");
    }

    private boolean isAssetDecisionTable(AssetItem assetItem) {
        return "gdst".equals(assetItem.getFormat()) || "xls".equals(assetItem.getFormat());
    }

    protected AssetValidationIterator listAssetsByFormat(String format) {
        AssetValidationIterator assetValidationIterator = new AssetValidationIterator((Iterator)this.packageItem.listAssetsByFormat(new String[]{format}));
        if (this.assetItem.getFormat().equals(format)) {
            assetValidationIterator.setAssetItemUnderValidation(this.assetItem);
        }
        return assetValidationIterator;
    }
}

