/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellFactory;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableControlsWidget;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.guvnor.client.util.GWTDateConverter;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.HasColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.HasRows;
import org.drools.guvnor.client.widgets.decoratedgrid.HasSystemControlledColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.MergableGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicData;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicDataRow;
import org.drools.guvnor.client.widgets.decoratedgrid.data.GroupedDynamicDataRow;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DescriptionCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDecisionTableWidget
extends Composite
implements HasRows,
HasColumns<DTColumnConfig52>,
HasSystemControlledColumns {
    protected GuidedDecisionTable52 model;
    protected DecoratedGridWidget<DTColumnConfig52> widget;
    protected SuggestionCompletionEngine sce;
    protected DecisionTableCellFactory cellFactory;
    protected DecisionTableCellValueFactory cellValueFactory;
    protected DecisionTableControlsWidget dtableCtrls;

    public AbstractDecisionTableWidget(DecisionTableControlsWidget dtableCtrls, SuggestionCompletionEngine sce) {
        if (dtableCtrls == null) {
            throw new IllegalArgumentException("dtableControls cannot be null");
        }
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        this.sce = sce;
        this.dtableCtrls = dtableCtrls;
        this.dtableCtrls.setDecisionTableWidget(this);
    }

    public void addColumn(DTColumnConfig52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.addColumn(modelColumn, true);
    }

    public void appendRow() {
        this.insertRowBefore(null);
    }

    public void deleteColumn(DTColumnConfig52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        DynamicColumn col = this.getDynamicColumn(modelColumn);
        this.widget.deleteColumn(col);
    }

    public void deleteRow(DynamicDataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.widget.deleteRow(row);
        this.updateSystemControlledColumnValues();
        this.redrawSystemControlledColumns();
    }

    public GuidedDecisionTable52 getModel() {
        return this.model;
    }

    public SuggestionCompletionEngine getSCE() {
        return this.sce;
    }

    public void insertRowBefore(DynamicDataRow rowBefore) {
        List rowData = this.makeRowData();
        this.widget.insertRowBefore(rowBefore, rowData);
        this.redrawSystemControlledColumns();
    }

    public void makeOtherwiseCell() {
        MergableGridWidget grid = this.widget.getGridWidget();
        List selections = grid.getSelectedCells();
        CellValue cell = (CellValue)selections.get(0);
        if (this.canAcceptOtherwiseValues(cell)) {
            for (CellValue cv : selections) {
                cv.addState(CellValue.CellState.OTHERWISE);
            }
            grid.update(null);
        }
    }

    public void redrawSystemControlledColumns() {
        this.widget.redrawSystemControlledColumns();
    }

    public void scrapeColumns() {
        RowNumberCol52 rnCol = null;
        DescriptionCol52 descCol = null;
        ArrayList<MetadataCol52> newMetaColumns = new ArrayList<MetadataCol52>();
        ArrayList<MetadataCol52> newAttributeColumns = new ArrayList<MetadataCol52>();
        ArrayList<Pattern52> newPatterns = new ArrayList<Pattern52>();
        ArrayList<MetadataCol52> newActionColumns = new ArrayList<MetadataCol52>();
        for (DynamicColumn column : this.widget.getGridWidget().getColumns()) {
            MetadataCol52 tc;
            DTColumnConfig52 modelCol = (DTColumnConfig52)column.getModelColumn();
            if (modelCol instanceof RowNumberCol52) {
                rnCol = (RowNumberCol52)modelCol;
                rnCol.setWidth(column.getWidth());
                rnCol.setHideColumn(!column.isVisible());
                this.model.setRowNumberCol(rnCol);
                continue;
            }
            if (modelCol instanceof DescriptionCol52) {
                descCol = (DescriptionCol52)modelCol;
                descCol.setWidth(column.getWidth());
                descCol.setHideColumn(!column.isVisible());
                this.model.setDescriptionCol(descCol);
                continue;
            }
            if (modelCol instanceof MetadataCol52) {
                tc = (MetadataCol52)modelCol;
                tc.setWidth(column.getWidth());
                tc.setHideColumn(!column.isVisible());
                newMetaColumns.add(tc);
                continue;
            }
            if (modelCol instanceof AttributeCol52) {
                tc = (AttributeCol52)modelCol;
                tc.setWidth(column.getWidth());
                tc.setHideColumn(!column.isVisible());
                newAttributeColumns.add(tc);
                continue;
            }
            if (modelCol instanceof ConditionCol52) {
                tc = (ConditionCol52)modelCol;
                tc.setWidth(column.getWidth());
                tc.setHideColumn(!column.isVisible());
                Pattern52 p = this.model.getPattern((ConditionCol52)tc);
                Pattern52 newPattern = this.getExistingNewPattern(newPatterns, p);
                if (newPattern == null) {
                    newPattern = this.clonePatternExcludingConditions(p);
                    newPatterns.add(newPattern);
                }
                newPattern.getConditions().add(tc);
                continue;
            }
            if (!(modelCol instanceof ActionCol52)) continue;
            tc = (ActionCol52)modelCol;
            tc.setWidth(column.getWidth());
            tc.setHideColumn(!column.isVisible());
            newActionColumns.add(tc);
        }
        this.model.setMetadataCols(newMetaColumns);
        this.model.setAttributeCols(newAttributeColumns);
        this.model.setConditionPatterns(newPatterns);
        this.model.setActionCols(newActionColumns);
    }

    private Pattern52 clonePatternExcludingConditions(Pattern52 p) {
        Pattern52 newPattern = new Pattern52();
        newPattern.setBoundName(p.getBoundName());
        newPattern.setEntryPointName(p.getEntryPointName());
        newPattern.setFactType(p.getFactType());
        newPattern.setNegated(p.isNegated());
        newPattern.setWindow(p.getWindow());
        return newPattern;
    }

    private Pattern52 getExistingNewPattern(List<Pattern52> newPatterns, Pattern52 pattern) {
        for (Pattern52 p : newPatterns) {
            if (!p.getBoundName().equals(pattern.getBoundName())) continue;
            return p;
        }
        return null;
    }

    public void scrapeData() {
        DynamicData data = this.widget.getGridWidget().getData().getFlattenedData();
        List columns = this.widget.getGridWidget().getColumns();
        int GRID_ROWS = data.size();
        ArrayList grid = new ArrayList();
        for (int iRow = 0; iRow < GRID_ROWS; ++iRow) {
            DynamicDataRow dataRow = data.get(iRow);
            ArrayList<DTCellValue52> row = new ArrayList<DTCellValue52>();
            for (int iCol = 0; iCol < columns.size(); ++iCol) {
                CellValue cv = dataRow.get(iCol);
                DTColumnConfig52 column = (DTColumnConfig52)((DynamicColumn)columns.get(iCol)).getModelColumn();
                DTCellValue52 dcv = this.cellValueFactory.convertToDTModelCell(column, cv);
                dcv.setOtherwise(cv.isOtherwise());
                row.add(dcv);
            }
            grid.add(row);
        }
        this.model.setData(grid);
    }

    public void setColumnVisibility(DTColumnConfig52 modelColumn, boolean isVisible) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null");
        }
        DynamicColumn col = this.getDynamicColumn(modelColumn);
        this.widget.setColumnVisibility(col.getColumnIndex(), isVisible);
    }

    public void setModel(GuidedDecisionTable52 model) {
        DynamicColumn column;
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
        this.cellFactory = new DecisionTableCellFactory(this.sce, this.widget.getGridWidget(), this.model);
        this.cellValueFactory = new DecisionTableCellValueFactory(this.sce, this.model);
        DecisionTableCellValueFactory.injectDateConvertor((DateConverter)GWTDateConverter.getInstance());
        this.widget.getGridWidget().getData().setOnRowChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        this.widget.getGridWidget().getData().clear();
        this.widget.getGridWidget().getColumns().clear();
        DynamicData data = this.widget.getGridWidget().getData();
        for (int iRow = 0; iRow < model.getData().size(); ++iRow) {
            data.addRow();
        }
        int colIndex = 0;
        RowNumberCol52 colStatic = model.getRowNumberCol();
        DynamicColumn columnStatic = new DynamicColumn((Object)colStatic, this.cellFactory.getCell((DTColumnConfig52)colStatic), colIndex, true, false);
        columnStatic.setWidth(24);
        this.widget.appendColumn(columnStatic, this.makeColumnData((DTColumnConfig52)colStatic, colIndex++), false);
        colStatic = model.getDescriptionCol();
        columnStatic = new DynamicColumn((Object)colStatic, this.cellFactory.getCell((DTColumnConfig52)colStatic), colIndex);
        this.widget.appendColumn(columnStatic, this.makeColumnData((DTColumnConfig52)colStatic, colIndex++), false);
        for (MetadataCol52 col : model.getMetadataCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig52)col), colIndex);
            column.setVisible(!col.isHideColumn());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig52)col, colIndex++), false);
        }
        for (MetadataCol52 col : model.getAttributeCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig52)col), colIndex);
            column.setVisible(!col.isHideColumn());
            column.setSystemControlled(col.isUseRowNumber());
            column.setSortable(!col.isUseRowNumber());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig52)col, colIndex++), false);
        }
        for (Pattern52 p : model.getConditionPatterns()) {
            for (ConditionCol52 col : p.getConditions()) {
                DynamicColumn column2 = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig52)col), colIndex);
                column2.setVisible(!col.isHideColumn());
                this.widget.appendColumn(column2, this.makeColumnData((DTColumnConfig52)col, colIndex++), false);
                ConditionCol52 cc = col;
                cc.setFieldType(this.sce.getFieldType(p.getFactType(), cc.getFactField()));
            }
        }
        for (MetadataCol52 col : model.getActionCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig52)col), colIndex);
            column.setVisible(!col.isHideColumn());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig52)col, colIndex++), false);
        }
        this.updateSystemControlledColumnValues();
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.widget.setPixelSize(width, height);
    }

    public void updateColumn(ActionInsertFactCol52 origColumn, ActionInsertFactCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        boolean bUpdateCellsForDataType = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig52)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getBoundName(), editColumn.getBoundName())) {
            if (!this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) || !this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
                bRedrawColumn = true;
                bUpdateCellsForDataType = true;
            }
        } else if (!this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) || !this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
            bRedrawColumn = true;
            bUpdateCellsForDataType = true;
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            boolean bl = bRedrawColumn = bRedrawColumn || this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateCellsForDataType) {
            this.updateCellsForDataType((DTColumnConfig52)origColumn, column);
        }
        if (bRedrawColumn) {
            int maxColumnIndex = this.widget.getGridWidget().getColumns().size() - 1;
            this.widget.getGridWidget().redrawColumns(column.getColumnIndex(), maxColumnIndex);
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateColumn(ActionSetFieldCol52 origColumn, ActionSetFieldCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        boolean bUpdateCellsForDataType = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig52)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getBoundName(), editColumn.getBoundName())) {
            if (!this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
                bRedrawColumn = true;
                bUpdateCellsForDataType = true;
            }
        } else if (!this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
            bRedrawColumn = true;
            bUpdateCellsForDataType = true;
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            boolean bl = bRedrawColumn = bRedrawColumn || this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateCellsForDataType) {
            this.updateCellsForDataType((DTColumnConfig52)origColumn, column);
        }
        if (bRedrawColumn) {
            int maxColumnIndex = this.widget.getGridWidget().getColumns().size() - 1;
            this.widget.getGridWidget().redrawColumns(column.getColumnIndex(), maxColumnIndex);
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateColumn(Pattern52 origPattern, ConditionCol52 origColumn, Pattern52 editPattern, ConditionCol52 editColumn) {
        if (origPattern == null) {
            throw new IllegalArgumentException("origPattern cannot be null");
        }
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editPattern == null) {
            throw new IllegalArgumentException("editPattern cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        boolean bUpdateCellsForDataType = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig52)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getOperator(), editColumn.getOperator())) {
            bRedrawHeader = true;
            if (!this.canAcceptOtherwiseValues((DTColumnConfig52)editColumn)) {
                this.removeOtherwiseStates(column);
                bRedrawColumn = true;
            }
        }
        if (!this.isEqualOrNull(origPattern.getBoundName(), editPattern.getBoundName())) {
            bRedrawHeader = true;
            this.addColumn((DTColumnConfig52)editColumn, false);
            DynamicColumn origCol = this.getDynamicColumn((DTColumnConfig52)origColumn);
            DynamicColumn editCol = this.getDynamicColumn((DTColumnConfig52)editColumn);
            int origColIndex = this.widget.getGridWidget().getColumns().indexOf(origCol);
            int editColIndex = this.widget.getGridWidget().getColumns().indexOf(editCol);
            if (this.isEqualOrNull(origPattern.getFactType(), editPattern.getFactType()) && this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField()) && origColumn.getConstraintValueType() == editColumn.getConstraintValueType()) {
                DynamicData data = this.widget.getGridWidget().getData();
                for (int iRow = 0; iRow < data.size(); ++iRow) {
                    DynamicDataRow row = data.get(iRow);
                    CellValue oldCell = row.get(origColIndex);
                    CellValue newCell = row.get(editColIndex);
                    newCell.setValue((Object)oldCell.getValue());
                }
            }
            this.widget.deleteColumn(origCol);
            editColIndex = Math.min(this.widget.getGridWidget().getColumns().size() - 1, editColIndex);
            if (editColIndex > origColIndex) {
                int temp = origColIndex;
                origColIndex = editColIndex;
                editColIndex = temp;
            }
            this.widget.getGridWidget().redrawColumns(editColIndex, origColIndex);
        } else if (!(this.isEqualOrNull(origPattern.getFactType(), editPattern.getFactType()) && this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField()) && this.isEqualOrNull(origColumn.getFieldType(), editColumn.getFieldType()) && this.isEqualOrNull(origColumn.getOperator(), editColumn.getOperator()) && origColumn.getConstraintValueType() == editColumn.getConstraintValueType())) {
            bRedrawColumn = true;
            bUpdateCellsForDataType = true;
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            boolean bl = bRedrawColumn = bRedrawColumn || this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        if (origColumn.getFactField() != null && !origColumn.getFactField().equals(editColumn.getFactField())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateCellsForDataType) {
            this.updateCellsForDataType((DTColumnConfig52)origColumn, column);
        }
        if (bRedrawColumn) {
            int maxColumnIndex = this.widget.getGridWidget().getColumns().size() - 1;
            this.widget.getGridWidget().redrawColumns(column.getColumnIndex(), maxColumnIndex);
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateSystemControlledColumnValues() {
        DynamicData data = this.widget.getGridWidget().getData();
        List columns = this.widget.getGridWidget().getColumns();
        for (DynamicColumn col : columns) {
            AttributeCol52 attrCol;
            DTColumnConfig52 modelColumn = (DTColumnConfig52)col.getModelColumn();
            if (modelColumn instanceof RowNumberCol52) {
                this.updateRowNumberColumnValues(data, col.getColumnIndex());
                continue;
            }
            if (!(modelColumn instanceof AttributeCol52) || !(attrCol = (AttributeCol52)modelColumn).getAttribute().equals("salience")) continue;
            if (attrCol.isUseRowNumber()) {
                this.updateSalienceColumnValues(data, col.getColumnIndex(), attrCol.isReverseOrder());
            }
            col.setCell(this.cellFactory.getCell((DTColumnConfig52)attrCol));
            col.setSystemControlled(attrCol.isUseRowNumber());
            col.setSortable(!attrCol.isUseRowNumber());
        }
    }

    private void addColumn(DTColumnConfig52 modelColumn, boolean bRedraw) {
        int index = 0;
        if (modelColumn instanceof MetadataCol52) {
            index = this.findMetadataColumnIndex();
        } else if (modelColumn instanceof AttributeCol52) {
            index = this.findAttributeColumnIndex();
        } else if (modelColumn instanceof ConditionCol52) {
            index = this.findConditionColumnIndex((ConditionCol52)modelColumn);
        } else if (modelColumn instanceof ActionCol52) {
            index = this.findActionColumnIndex();
        }
        this.insertColumnBefore(modelColumn, index, bRedraw);
    }

    private boolean canAcceptOtherwiseValues(DTColumnConfig52 column) {
        if (!(column instanceof ConditionCol52)) {
            return false;
        }
        ConditionCol52 cc = (ConditionCol52)column;
        if (cc.getConstraintValueType() != 1) {
            return false;
        }
        if (cc.getOperator() == null) {
            return false;
        }
        if (cc.getOperator().equals("==")) {
            return true;
        }
        return cc.getOperator().equals("!=");
    }

    private int findActionColumnIndex() {
        int index = this.widget.getGridWidget().getColumns().size() - 1;
        return index;
    }

    private int findAttributeColumnIndex() {
        int index = 0;
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig52 modelColumn = (DTColumnConfig52)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol52) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol52) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof MetadataCol52) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof AttributeCol52)) continue;
            index = iCol;
        }
        return index;
    }

    private int findConditionColumnIndex(ConditionCol52 col) {
        int index = 0;
        boolean bMatched = false;
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig52 modelColumn = (DTColumnConfig52)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol52) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol52) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof MetadataCol52) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof AttributeCol52) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof ConditionCol52)) continue;
            if (this.isEquivalentConditionColumn((ConditionCol52)modelColumn, col)) {
                index = iCol;
                bMatched = true;
                continue;
            }
            if (bMatched) continue;
            index = iCol;
        }
        return index;
    }

    private int findMetadataColumnIndex() {
        int index = 0;
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig52 modelColumn = (DTColumnConfig52)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol52) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol52) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof MetadataCol52)) continue;
            index = iCol;
        }
        return index;
    }

    private DynamicColumn<DTColumnConfig52> getDynamicColumn(DTColumnConfig52 modelCol) {
        DynamicColumn column = null;
        List columns = this.widget.getGridWidget().getColumns();
        for (DynamicColumn dc : columns) {
            if (!((DTColumnConfig52)dc.getModelColumn()).equals(modelCol)) continue;
            column = dc;
            break;
        }
        return column;
    }

    private void insertColumnBefore(DTColumnConfig52 modelColumn, int index, boolean bRedraw) {
        DynamicColumn column = new DynamicColumn((Object)modelColumn, this.cellFactory.getCell(modelColumn), index);
        column.setVisible(!modelColumn.isHideColumn());
        DynamicColumn columnBefore = (DynamicColumn)this.widget.getGridWidget().getColumns().get(index);
        DynamicData data = this.widget.getGridWidget().getData();
        ArrayList<CellValue> columnData = new ArrayList<CellValue>();
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DTCellValue52 dcv = new DTCellValue52(modelColumn.getDefaultValue());
            CellValue cell = this.cellValueFactory.makeCellValue(modelColumn, iRow, index, dcv);
            columnData.add(cell);
        }
        this.widget.insertColumnBefore(columnBefore, column, columnData, bRedraw);
    }

    private boolean isEqualOrNull(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s2 != null && s1.equals(s2);
    }

    private boolean isEquivalentConditionColumn(ConditionCol52 c1, ConditionCol52 c2) {
        Pattern52 c1Pattern = this.model.getPattern(c1);
        Pattern52 c2Pattern = this.model.getPattern(c2);
        return this.isEqualOrNull(c1Pattern.getFactType(), c2Pattern.getFactType()) && this.isEqualOrNull(c1Pattern.getBoundName(), c2Pattern.getBoundName());
    }

    private List<CellValue<? extends Comparable<?>>> makeColumnData(DTColumnConfig52 column, int colIndex) {
        int dataSize = this.model.getData().size();
        ArrayList columnData = new ArrayList();
        for (int iRow = 0; iRow < dataSize; ++iRow) {
            List row = (List)this.model.getData().get(iRow);
            DTCellValue52 dcv = (DTCellValue52)row.get(colIndex);
            CellValue cv = this.cellValueFactory.makeCellValue(column, iRow, colIndex, dcv);
            columnData.add(cv);
        }
        return columnData;
    }

    private List<CellValue<? extends Comparable<?>>> makeRowData() {
        ArrayList rowData = new ArrayList();
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DTColumnConfig52 col = (DTColumnConfig52)((DynamicColumn)columns.get(iCol)).getModelColumn();
            DTCellValue52 dcv = new DTCellValue52(col.getDefaultValue());
            CellValue cv = this.cellValueFactory.makeCellValue(col, 0, iCol, dcv);
            rowData.add(cv);
        }
        return rowData;
    }

    private void populateModelColumn(ActionInsertFactCol52 col, ActionInsertFactCol52 editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setFactType(editingCol.getFactType());
        col.setInsertLogical(editingCol.isInsertLogical());
    }

    private void populateModelColumn(ActionSetFieldCol52 col, ActionSetFieldCol52 editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setUpdate(editingCol.isUpdate());
    }

    private void populateModelColumn(ConditionCol52 col, ConditionCol52 editingCol) {
        col.setConstraintValueType(editingCol.getConstraintValueType());
        col.setFactField(editingCol.getFactField());
        col.setFieldType(editingCol.getFieldType());
        col.setHeader(editingCol.getHeader());
        col.setOperator(editingCol.getOperator());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setParameters(editingCol.getParameters());
    }

    private void removeOtherwiseStates(DynamicColumn<DTColumnConfig52> column) {
        if (this.widget.getGridWidget().getData().isMerged()) {
            this.widget.getGridWidget().toggleMerging();
        }
        DynamicData data = this.widget.getGridWidget().getData();
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = data.get(iRow);
            CellValue cv = row.get(column.getColumnIndex());
            cv.removeState(CellValue.CellState.OTHERWISE);
        }
    }

    private void updateCellsForDataType(DTColumnConfig52 editColumn, DynamicColumn<DTColumnConfig52> column) {
        if (this.widget.getGridWidget().getData().isMerged()) {
            this.widget.getGridWidget().toggleMerging();
        }
        DynamicData data = this.widget.getGridWidget().getData();
        column.setCell(this.cellFactory.getCell(editColumn));
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = data.get(iRow);
            row.set(column.getColumnIndex(), this.cellValueFactory.makeCellValue((Object)editColumn, iRow, column.getColumnIndex()));
        }
    }

    private boolean updateCellsForOptionValueList(DTColumnConfig52 editColumn, DynamicColumn<DTColumnConfig52> column) {
        boolean bRedrawRequired = false;
        DynamicData data = this.widget.getGridWidget().getData();
        List<String> vals = Arrays.asList(this.model.getValueList(editColumn, this.sce));
        column.setCell(this.cellFactory.getCell(editColumn));
        int iCol = column.getColumnIndex();
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = data.get(iRow);
            if (vals.contains(row.get(iCol).getValue())) continue;
            row.get(iCol).setValue(null);
            bRedrawRequired = true;
        }
        return bRedrawRequired;
    }

    private void updateRowNumberColumnValues(DynamicData data, int iCol) {
        int iRowNum = 1;
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = data.get(iRow);
            if (row instanceof GroupedDynamicDataRow) {
                GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
                groupedRow.get(iCol).setValue((Object)new BigDecimal(iRowNum));
                for (int iGroupedRow = 0; iGroupedRow < groupedRow.getChildRows().size(); ++iGroupedRow) {
                    ((DynamicDataRow)groupedRow.getChildRows().get(iGroupedRow)).get(iCol).setValue((Object)new BigDecimal(iRowNum));
                    ++iRowNum;
                }
                continue;
            }
            row.get(iCol).setValue((Object)new BigDecimal(iRowNum));
            ++iRowNum;
        }
    }

    private void updateSalienceColumnValues(DynamicData data, int iCol, boolean isReverseOrder) {
        if (!isReverseOrder) {
            this.updateRowNumberColumnValues(data, iCol);
        } else {
            int rowCount = 0;
            for (int iRow = 0; iRow < data.size(); ++iRow) {
                DynamicDataRow row = data.get(iRow);
                if (row instanceof GroupedDynamicDataRow) {
                    GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
                    rowCount += groupedRow.getChildRows().size();
                    continue;
                }
                ++rowCount;
            }
            int iRowNum = 0;
            for (int iRow = 0; iRow < data.size(); ++iRow) {
                DynamicDataRow row = data.get(iRow);
                if (row instanceof GroupedDynamicDataRow) {
                    GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
                    groupedRow.get(iCol).setValue((Object)new BigDecimal(rowCount - iRowNum));
                    for (int iGroupedRow = 0; iGroupedRow < groupedRow.getChildRows().size(); ++iGroupedRow) {
                        ((DynamicDataRow)groupedRow.getChildRows().get(iGroupedRow)).get(iCol).setValue((Object)new BigDecimal(rowCount - iRowNum));
                        ++iRowNum;
                    }
                    continue;
                }
                row.get(iCol).setValue((Object)new BigDecimal(rowCount - iRowNum));
                ++iRowNum;
            }
        }
    }

    protected boolean canAcceptOtherwiseValues(CellValue<?> cell) {
        Coordinate c = cell.getCoordinate();
        MergableGridWidget grid = this.widget.getGridWidget();
        DynamicColumn column = (DynamicColumn)grid.getColumns().get(c.getCol());
        return this.canAcceptOtherwiseValues((DTColumnConfig52)column.getModelColumn());
    }
}

