/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.util.NumbericFilterKeyPressHandler;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionValueEditor
extends DirtyableComposite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private Images images = (Images)GWT.create(Images.class);
    private ActionFieldValue value;
    private DropDownData enums;
    private SimplePanel root;
    private RuleModeller model = null;
    private String variableType = null;
    private boolean readOnly;
    private Command onChangeCommand;

    public ActionValueEditor(ActionFieldValue val, DropDownData enums, boolean readOnly) {
        this(val, enums, null, null, readOnly);
    }

    public ActionValueEditor(ActionFieldValue val, DropDownData enums) {
        this(val, enums, false);
    }

    public ActionValueEditor(ActionFieldValue val, DropDownData enums, RuleModeller model, String variableType) {
        this(val, enums, model, variableType, false);
    }

    public ActionValueEditor(ActionFieldValue val, DropDownData enums, RuleModeller model, String variableType, boolean readOnly) {
        this.readOnly = readOnly;
        this.enums = val.type.equals("Boolean") ? DropDownData.create((String[])new String[]{"true", "false"}) : enums;
        this.root = new SimplePanel();
        this.value = val;
        this.model = model;
        this.variableType = variableType;
        this.refresh();
        this.initWidget((Widget)this.root);
    }

    private void refresh() {
        this.root.clear();
        if (this.value.nature == 0L) {
            if (this.value.value != null && this.value.value.length() > 0) {
                this.value.nature = this.value.value.charAt(0) == '=' ? 2L : 1L;
            } else {
                this.root.add(this.choice());
                return;
            }
        }
        if (this.value.nature == 7L) {
            Widget box = this.boundTextBox(this.value);
            this.root.add(box);
            return;
        }
        if (this.value.nature == 2L) {
            Widget list = this.boundVariable((FieldNature)this.value);
            this.root.add(list);
            return;
        }
        if (this.enums != null && (this.enums.fixedList != null || this.enums.queryExpression != null)) {
            Widget list = this.boundEnum((FieldNature)this.value);
            this.root.add(list);
            return;
        }
        Widget box = this.boundTextBox(this.value);
        this.root.add(box);
    }

    private Widget boundVariable(FieldNature c) {
        ListBox listVariable = new ListBox();
        listVariable.addItem(this.constants.Choose());
        List bindings = this.getApplicableBindings();
        for (String v : bindings) {
            listVariable.addItem(v);
        }
        if (this.value.value.equals("=")) {
            listVariable.setSelectedIndex(0);
        } else {
            for (int i = 0; i < listVariable.getItemCount(); ++i) {
                if (!listVariable.getItemText(i).equals(this.value.value.substring(1))) continue;
                listVariable.setSelectedIndex(i);
            }
        }
        if (listVariable.getItemCount() > 0) {
            listVariable.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.readOnly) {
            return new SmallLabel(listVariable.getItemText(listVariable.getSelectedIndex()));
        }
        return listVariable;
    }

    private Widget boundEnum(FieldNature c) {
        EnumDropDown enumDropDown = new EnumDropDown(this.value.value, (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, this.enums);
        if (this.readOnly) {
            return new SmallLabel(enumDropDown.getItemText(enumDropDown.getSelectedIndex()));
        }
        return enumDropDown;
    }

    private Widget boundTextBox(ActionFieldValue c) {
        TextBox box = new TextBox();
        box.setStyleName("constraint-value-Editor");
        if (c.value == null) {
            box.setText("");
        } else {
            if (c.value.trim().equals("")) {
                c.value = "";
            }
            box.setText(c.value);
        }
        if (c.value == null || c.value.length() < 5) {
            box.setVisibleLength(6);
        } else {
            box.setVisibleLength(c.value.length() - 1);
        }
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        box.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (this.value.nature != 7L && this.value.type.equals("Numeric")) {
            box.addKeyPressHandler((KeyPressHandler)new NumbericFilterKeyPressHandler(box));
        }
        if (this.readOnly) {
            return new SmallLabel(box.getText());
        }
        return box;
    }

    private Widget choice() {
        if (this.readOnly) {
            return new HTML();
        }
        Image clickme = new Image(this.images.edit());
        clickme.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return clickme;
    }

    protected void showTypeChoice(Widget w) {
        FormStylePopup form = new FormStylePopup(this.images.newexWiz(), this.constants.FieldValue());
        Button lit = new Button(this.constants.LiteralValue());
        lit.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.LiteralValue() + ":", this.widgets(lit, new InfoPopup(this.constants.Literal(), this.constants.ALiteralValueMeansTheValueAsTypedInIeItsNotACalculation())));
        if (this.model.isTemplate()) {
            Button templateButton = new Button(this.constants.TemplateKey());
            templateButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(this.constants.TemplateKey() + ":", this.widgets(templateButton, new InfoPopup(this.constants.Literal(), this.constants.ALiteralValueMeansTheValueAsTypedInIeItsNotACalculation())));
        }
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(this.constants.AdvancedSection()));
        Button formula = new Button(this.constants.Formula());
        formula.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        List bindings = this.getApplicableBindings();
        if (bindings.size() > 0) {
            Button variable = new Button(this.constants.BoundVariable());
            form.addAttribute(this.constants.BoundVariable() + ":", (Widget)variable);
            variable.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        form.addAttribute(this.constants.Formula() + ":", this.widgets(formula, new InfoPopup(this.constants.Formula(), this.constants.FormulaTip())));
        form.show();
    }

    private List<String> getApplicableBindings() {
        ArrayList<String> bindings = new ArrayList<String>();
        for (String v : this.model.getModel().getAllVariables()) {
            ActionInsertFact aif;
            FieldConstraint fc;
            FactPattern fp = this.model.getModel().getLHSBoundFact(v);
            if (fp != null && this.isLHSFactTypeEquivalent(v)) {
                bindings.add(v);
            }
            if ((fc = this.model.getModel().getLHSBoundField(v)) != null && this.isLHSFieldTypeEquivalent(v)) {
                bindings.add(v);
            }
            if ((aif = this.model.getModel().getRHSBoundFact(v)) == null || !this.isRHSFieldTypeEquivalent(v)) continue;
            bindings.add(v);
        }
        return bindings;
    }

    private boolean isLHSFactTypeEquivalent(String boundVariable) {
        String boundFactType = this.model.getModel().getLHSBoundFact(boundVariable).getFactType();
        if (boundFactType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            String[] dd = this.model.getSuggestionCompletions().getEnumValues(boundFactType, this.value.field);
            return this.isEnumEquivalent(dd);
        }
        return boundFactType.equals(this.variableType);
    }

    private boolean isLHSFieldTypeEquivalent(String boundVariable) {
        String boundFieldType = this.model.getModel().getLHSBindingType(boundVariable);
        if (boundFieldType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            FieldConstraint fc = this.model.getModel().getLHSBoundField(boundVariable);
            if (fc instanceof SingleFieldConstraint) {
                String fieldName = ((SingleFieldConstraint)fc).getFieldName();
                String parentFactTypeForBinding = this.model.getModel().getLHSParentFactPatternForBinding(boundVariable).getFactType();
                String[] dd = this.model.getSuggestionCompletions().getEnumValues(parentFactTypeForBinding, fieldName);
                return this.isEnumEquivalent(dd);
            }
            return false;
        }
        return boundFieldType.equals(this.variableType);
    }

    private boolean isRHSFieldTypeEquivalent(String boundVariable) {
        String boundFactType = this.model.getModel().getRHSBoundFact((String)boundVariable).factType;
        if (boundFactType == null) {
            return false;
        }
        if (this.variableType == null) {
            return false;
        }
        if (boundFactType.equals("Comparable")) {
            if (!this.variableType.equals("Comparable")) {
                return false;
            }
            String[] dd = this.model.getSuggestionCompletions().getEnumValues(boundFactType, this.value.field);
            return this.isEnumEquivalent(dd);
        }
        return boundFactType.equals(this.variableType);
    }

    private boolean isEnumEquivalent(String[] values) {
        if (values == null && this.enums.fixedList != null) {
            return false;
        }
        if (values != null && this.enums.fixedList == null) {
            return false;
        }
        if (values.length != this.enums.fixedList.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equals(this.enums.fixedList[i])) continue;
            return false;
        }
        return true;
    }

    private Widget widgets(Button lit, InfoPopup popup) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)lit);
        h.add((Widget)popup);
        return h;
    }

    private void executeOnChageCommand() {
        if (this.onChangeCommand != null) {
            this.onChangeCommand.execute();
        }
    }

    public Command getOnChangeCommand() {
        return this.onChangeCommand;
    }

    public void setOnChangeCommand(Command onChangeCommand) {
        this.onChangeCommand = onChangeCommand;
    }

    static /* synthetic */ ActionFieldValue access$000(ActionValueEditor x0) {
        return x0.value;
    }

    static /* synthetic */ void access$100(ActionValueEditor x0) {
        x0.executeOnChageCommand();
    }

    static /* synthetic */ void access$200(ActionValueEditor x0) {
        x0.refresh();
    }
}

