/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.modeldriven.SetFactTypeFilter;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.packages.WorkingSetManager;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.client.factconstraints.customform.CustomFormConfiguration;
import org.drools.ide.common.client.factconstraints.helper.CustomFormsContainer;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetManager {
    private static WorkingSetManager INSTANCE = new WorkingSetManager();
    private Map<String, Set<RuleAsset>> activeWorkingSets = new HashMap();
    private boolean autoVerifierEnabled = false;

    public static synchronized WorkingSetManager getInstance() {
        return INSTANCE;
    }

    public void applyWorkingSets(String packageName, String[] wsUUIDs, Command done) {
        RepositoryServiceFactory.getAssetService().loadRuleAssets(wsUUIDs, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void applyWorkingSets(String packageName, Set<RuleAsset> wss, Command done) {
        this.applyWorkingSets(packageName, wss, false, done);
    }

    public void applyTemporalWorkingSetForFactTypes(String packageName, Set<String> factTypes, Command done) {
        2 workingSets = null;
        if (factTypes != null && !factTypes.isEmpty()) {
            RuleAsset workingSet = new RuleAsset();
            workingSet.setUuid("workingSetMock");
            WorkingSetConfigData wsConfig = new WorkingSetConfigData();
            wsConfig.validFacts = factTypes.toArray(new String[factTypes.size()]);
            workingSet.setContent((PortableObject)wsConfig);
            workingSets = new /* Unavailable Anonymous Inner Class!! */;
        }
        this.applyWorkingSets(packageName, workingSets, true, done);
    }

    private void applyWorkingSets(String packageName, Set<RuleAsset> wss, boolean temporal, Command done) {
        3 cmd = new /* Unavailable Anonymous Inner Class!! */;
        if (wss == null || wss.isEmpty()) {
            SuggestionCompletionCache.getInstance().refreshPackage(packageName, (Command)cmd);
            if (!temporal) {
                this.activeWorkingSets.remove(packageName);
            }
            return;
        }
        HashSet<String> validFacts = new HashSet<String>();
        for (RuleAsset asset : wss) {
            WorkingSetConfigData wsConfig = (WorkingSetConfigData)asset.getContent();
            if (wsConfig.validFacts == null || wsConfig.validFacts.length <= 0) continue;
            validFacts.addAll(Arrays.asList(wsConfig.validFacts));
        }
        SuggestionCompletionCache.getInstance().applyFactFilter(packageName, (FactTypeFilter)new SetFactTypeFilter(validFacts), (Command)cmd);
    }

    public Set<RuleAsset> getActiveAssets(String packageName) {
        return (Set)this.activeWorkingSets.get(packageName);
    }

    public Set<String> getActiveAssetUUIDs(String packageName) {
        Set assets = (Set)this.activeWorkingSets.get(packageName);
        if (assets == null) {
            return null;
        }
        HashSet<String> uuids = new HashSet<String>(assets.size());
        for (RuleAsset asset : assets) {
            uuids.add(asset.getUuid());
        }
        return uuids;
    }

    public Set<WorkingSetConfigData> getActiveWorkingSets(String packageName) {
        Set assets = (Set)this.activeWorkingSets.get(packageName);
        if (assets == null) {
            return null;
        }
        HashSet<WorkingSetConfigData> result = new HashSet<WorkingSetConfigData>();
        for (RuleAsset ruleAsset : assets) {
            result.add((WorkingSetConfigData)ruleAsset.getContent());
        }
        return result;
    }

    public boolean isWorkingSetActive(String packageName, RuleAsset workingSetAsset) {
        return this.isWorkingSetActive(packageName, workingSetAsset.getUuid());
    }

    public boolean isWorkingSetActive(String packageName, String ruleAssetUUID) {
        if (!this.activeWorkingSets.containsKey(packageName)) {
            return false;
        }
        Set wss = (Set)this.activeWorkingSets.get(packageName);
        for (RuleAsset asset : wss) {
            if (!asset.getUuid().equals(ruleAssetUUID)) continue;
            return true;
        }
        return false;
    }

    public Set<ConstraintConfiguration> getFieldContraints(String packageName, String factType, String fieldName) {
        HashSet<ConstraintConfiguration> result = new HashSet<ConstraintConfiguration>();
        Set activeAssets = this.getActiveAssets(packageName);
        if (activeAssets != null) {
            for (RuleAsset ruleAsset : activeAssets) {
                List constraints = ((WorkingSetConfigData)ruleAsset.getContent()).constraints;
                if (constraints == null) continue;
                for (ConstraintConfiguration constraint : constraints) {
                    if (!constraint.getFactType().equals(factType) || !constraint.getFieldName().equals(fieldName)) continue;
                    result.add(constraint);
                }
            }
        }
        return result;
    }

    public boolean isAutoVerifierEnabled() {
        return this.autoVerifierEnabled;
    }

    public void setAutoVerifierEnabled(boolean autoVerifierEnabled) {
        this.autoVerifierEnabled = autoVerifierEnabled;
    }

    public CustomFormConfiguration getCustomFormConfiguration(String packageName, String factType, String fieldName) {
        Set packageWorkingSets = this.getActiveWorkingSets(packageName);
        if (packageWorkingSets != null) {
            ArrayList configs = new ArrayList();
            for (WorkingSetConfigData workingSetConfigData : packageWorkingSets) {
                if (workingSetConfigData.customForms == null || workingSetConfigData.customForms.isEmpty()) continue;
                configs.addAll(workingSetConfigData.customForms);
            }
            CustomFormsContainer cfc = new CustomFormsContainer(configs);
            if (cfc.containsCustomFormFor(factType, fieldName)) {
                return cfc.getCustomForm(factType, fieldName);
            }
        }
        return null;
    }

    static /* synthetic */ Map access$000(WorkingSetManager x0) {
        return x0.activeWorkingSets;
    }
}

