/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.ArtifactEditor;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.RefreshAssetEditorEvent;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.RuleViewerSettings;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbar;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbarButtonsConfigurationProvider;

public class RuleViewerWrapper
extends GuvnorEditor
implements RefreshAssetEditorEvent.Handler {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private RuleAsset asset;
    private boolean isHistoricalReadOnly = false;
    private final RuleViewerSettings ruleViewerSettings;
    ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider;
    VerticalPanel layout = new VerticalPanel();
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public RuleViewerWrapper(ClientFactory clientFactory, EventBus eventBus, RuleAsset asset) {
        this(clientFactory, eventBus, asset, false, null);
    }

    public RuleViewerWrapper(ClientFactory clientFactory, EventBus eventBus, RuleAsset asset, boolean isHistoricalReadOnly, RuleViewerSettings ruleViewerSettings) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.asset = asset;
        this.isHistoricalReadOnly = isHistoricalReadOnly;
        this.ruleViewerSettings = ruleViewerSettings;
        eventBus.addHandler(RefreshAssetEditorEvent.TYPE, (EventHandler)this);
        this.initWidget((Widget)this.layout);
        this.render();
        this.setWidth("100%");
    }

    private void render() {
        ArtifactEditor artifactEditor = new ArtifactEditor(this.clientFactory, this.eventBus, (Artifact)this.asset, this.isHistoricalReadOnly);
        RuleViewer ruleViewer = new RuleViewer(this.asset, this.clientFactory, this.eventBus, this.isHistoricalReadOnly, this.actionToolbarButtonsConfigurationProvider, this.ruleViewerSettings);
        ActionToolbar actionToolBar = ruleViewer.getActionToolbar();
        this.layout.clear();
        this.layout.add((Widget)actionToolBar);
        TabPanel tabPanel = new TabPanel();
        tabPanel.setWidth("100%");
        ScrollPanel scrollPanel = new ScrollPanel();
        scrollPanel.add((Widget)artifactEditor);
        tabPanel.add((Widget)scrollPanel, this.constants.Attributes());
        scrollPanel = new ScrollPanel();
        scrollPanel.add((Widget)ruleViewer);
        tabPanel.add((Widget)scrollPanel, this.constants.Edit());
        tabPanel.selectTab(1);
        this.layout.add((Widget)tabPanel);
    }

    public void onRefreshAsset(RefreshAssetEditorEvent refreshAssetEditorEvent) {
        if (refreshAssetEditorEvent.getUuid().equals(this.asset.getUuid())) {
            LoadingPopup.showMessage((String)this.constants.RefreshingItem());
            RepositoryServiceFactory.getAssetService().loadRuleAsset(this.asset.getUuid(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ RuleAsset access$002(RuleViewerWrapper x0, RuleAsset x1) {
        x0.asset = x1;
        return x0.asset;
    }

    static /* synthetic */ void access$100(RuleViewerWrapper x0) {
        x0.render();
    }
}

