/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.drools.guvnor.client.rpc.AdminArchivedPageRow;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.builder.AssetItemValidator;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.DSLLoader;
import org.drools.guvnor.server.builder.PageResponseBuilder;
import org.drools.guvnor.server.builder.pagerow.ArchivedAssetPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.AssetPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.QuickFindPageRowBuilder;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICanRenderSource;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.AssetEditorConfiguration;
import org.drools.guvnor.server.util.AssetEditorConfigurationParser;
import org.drools.guvnor.server.util.AssetFormatHelper;
import org.drools.guvnor.server.util.AssetLockManager;
import org.drools.guvnor.server.util.Discussion;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.MetaDataMapper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.VersionableItem;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.server.RepositoryAssetOperations")
@AutoCreate
public class RepositoryAssetOperations {
    private RulesRepository repository;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryAssetOperations.class);
    private final String[] registeredFormats;

    public RepositoryAssetOperations() {
        AssetEditorConfigurationParser parser = new AssetEditorConfigurationParser();
        List rfs = parser.getAssetEditors();
        this.registeredFormats = new String[rfs.size()];
        for (int i = 0; i < rfs.size(); ++i) {
            AssetEditorConfiguration config = (AssetEditorConfiguration)rfs.get(i);
            this.registeredFormats[i] = config.getFormat();
        }
    }

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    public String renameAsset(String uuid, String newName) {
        return this.getRulesRepository().renameAsset(uuid, newName);
    }

    protected BuilderResult validateAsset(RuleAsset asset) {
        try {
            ContentHandler handler = ContentManager.getHandler((String)asset.getFormat());
            AssetItem item = this.getRulesRepository().loadAssetByUUID(asset.uuid);
            handler.storeAssetContent(asset, item);
            AssetItemValidator assetItemValidator = new AssetItemValidator(handler, item);
            return assetItemValidator.validate();
        }
        catch (Exception e) {
            log.error("Unable to build asset.", (Throwable)e);
            BuilderResult result = new BuilderResult();
            result.addLine(this.createBuilderResultLine(asset));
            return result;
        }
    }

    private BuilderResultLine createBuilderResultLine(RuleAsset asset) {
        BuilderResultLine builderResultLine = new BuilderResultLine();
        builderResultLine.setAssetName(asset.name);
        builderResultLine.setAssetFormat(asset.getFormat());
        builderResultLine.setMessage("Unable to validate this asset. (Check log for detailed messages).");
        builderResultLine.setUuid(asset.uuid);
        return builderResultLine;
    }

    public String checkinVersion(RuleAsset asset) throws SerializationException {
        AssetItem repoAsset = this.getRulesRepository().loadAssetByUUID(asset.getUuid());
        if (this.isAssetUpdatedInRepository(asset, repoAsset)) {
            return "ERR: Unable to save this asset, as it has been recently updated by [" + repoAsset.getLastContributor() + "]";
        }
        MetaData meta = asset.getMetaData();
        MetaDataMapper.getInstance().copyFromMetaData(meta, (Object)repoAsset);
        repoAsset.updateDateEffective(this.dateToCalendar(meta.getDateEffective()));
        repoAsset.updateDateExpired(this.dateToCalendar(meta.getDateExpired()));
        repoAsset.updateCategoryList(meta.getCategories());
        repoAsset.updateDescription(asset.getDescription());
        ContentHandler handler = ContentManager.getHandler((String)repoAsset.getFormat());
        handler.storeAssetContent(asset, repoAsset);
        if (!asset.getFormat().equals("scenario") || asset.getFormat().equals("enumeration")) {
            PackageItem pkg = repoAsset.getPackage();
            pkg.updateBinaryUpToDate(false);
            RuleBaseCache.getInstance().remove(pkg.getUUID());
        }
        repoAsset.checkin(asset.getCheckinComment());
        return repoAsset.getUUID();
    }

    private Calendar dateToCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private boolean isAssetUpdatedInRepository(RuleAsset asset, AssetItem repoAsset) {
        return asset.getLastModified().before(repoAsset.getLastModified().getTime());
    }

    public void restoreVersion(String versionUUID, String assetUUID, String comment) {
        AssetItem old = this.getRulesRepository().loadAssetByUUID(versionUUID);
        AssetItem head = this.getRulesRepository().loadAssetByUUID(assetUUID);
        log.info("USER:" + this.getCurrentUserName() + " RESTORE of asset: [" + head.getName() + "] UUID: [" + head.getUUID() + "] with historical version number: [" + old.getVersionNumber());
        this.getRulesRepository().restoreHistoricalAsset(old, head, comment);
    }

    protected TableDataResult loadItemHistory(VersionableItem item) {
        Iterator it = item.getHistory();
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        while (it.hasNext()) {
            VersionableItem historical = (VersionableItem)it.next();
            long versionNumber = historical.getVersionNumber();
            if (!this.isHistory(item, versionNumber)) continue;
            result.add(this.createHistoricalRow(historical));
        }
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        return table;
    }

    private boolean isHistory(VersionableItem item, long versionNumber) {
        return versionNumber != 0L;
    }

    private TableDataRow createHistoricalRow(VersionableItem historical) {
        DateFormat dateFormatter = DateFormat.getInstance();
        TableDataRow tableDataRow = new TableDataRow();
        tableDataRow.id = historical.getVersionSnapshotUUID();
        tableDataRow.values = new String[4];
        tableDataRow.values[0] = Long.toString(historical.getVersionNumber());
        tableDataRow.values[1] = historical.getCheckinComment();
        tableDataRow.values[2] = dateFormatter.format(historical.getLastModified().getTime());
        tableDataRow.values[3] = historical.getStateDescription();
        return tableDataRow;
    }

    protected TableDataResult loadArchivedAssets(int skip, int numRows) {
        ArrayList<TableDataRow> result = new ArrayList<TableDataRow>();
        AssetItemFilter filter = new AssetItemFilter();
        AssetItemIterator it = this.getRulesRepository().findArchivedAssets();
        it.skip((long)skip);
        int count = 0;
        while (it.hasNext()) {
            AssetItem archived = it.next();
            if (filter.accept((Object)archived, "read")) {
                result.add(this.createArchivedRow(archived));
                ++count;
            }
            if (count != numRows) continue;
            break;
        }
        return this.createArchivedTable(result, it);
    }

    private TableDataRow createArchivedRow(AssetItem archived) {
        TableDataRow row = new TableDataRow();
        row.id = archived.getUUID();
        row.values = new String[5];
        row.values[0] = archived.getName();
        row.values[1] = archived.getFormat();
        row.values[2] = archived.getPackageName();
        row.values[3] = archived.getLastContributor();
        row.values[4] = Long.toString(archived.getLastModified().getTime().getTime());
        return row;
    }

    private TableDataResult createArchivedTable(List<TableDataRow> result, AssetItemIterator it) {
        TableDataResult table = new TableDataResult();
        table.data = result.toArray(new TableDataRow[result.size()]);
        table.currentPosition = it.getPosition();
        table.total = it.getSize();
        table.hasNext = it.hasNext();
        return table;
    }

    protected PageResponse<AdminArchivedPageRow> loadArchivedAssets(PageRequest request) {
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getRulesRepository().findArchivedAssets();
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        long totalRowsCount = iterator.getSize();
        List rowList = new ArchivedAssetPageRowBuilder().withPageRequest(request).withContent((Iterator)iterator).build();
        PageResponse response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!iterator.hasNext()).buildWithTotalRowCount(totalRowsCount);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Searched for Archived Assests in " + methodDuration + " ms.");
        return response;
    }

    protected TableDataResult listAssets(String packageUuid, String[] formats, int skip, int numRows, String tableConfig) {
        long start = System.currentTimeMillis();
        PackageItem pkg = this.getRulesRepository().loadPackageByUUID(packageUuid);
        AssetItemIterator it = formats.length > 0 ? pkg.listAssetsByFormat(formats) : pkg.listAssetsNotOfFormat(AssetFormatHelper.listRegisteredTypes());
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        log.debug("time for asset list load: " + (System.currentTimeMillis() - start));
        return handler.loadRuleListTable(it, skip, numRows);
    }

    protected TableDataResult quickFindAsset(String searchText, boolean searchArchived, int skip, int numRows) throws SerializationException {
        String search = searchText.replace('*', '%');
        if (!search.endsWith("%")) {
            search = search + "%";
        }
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        long start = System.currentTimeMillis();
        AssetItemIterator it = this.getRulesRepository().findAssetsByName(search, searchArchived);
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        AssetItemFilter filter = new AssetItemFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!filter.accept((Object)ai, RoleType.PACKAGE_READONLY.getName())) continue;
            resultList.add(ai);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    protected TableDataResult queryFullText(String text, boolean seekArchived, int skip, int numRows) throws SerializationException {
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        PackageFilter filter = new PackageFilter();
        AssetItemIterator assetItemIterator = this.getRulesRepository().queryFullText(text, seekArchived);
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = assetItemIterator.next();
            PackageConfigData data = new PackageConfigData();
            data.setUuid(assetItem.getPackage().getUUID());
            if (!filter.accept((Object)data, RoleType.PACKAGE_READONLY.getName())) continue;
            resultList.add(assetItem);
        }
        TableDisplayHandler handler = new TableDisplayHandler("searchresults");
        return handler.loadRuleListTable(resultList, skip, numRows);
    }

    protected String buildAssetSource(RuleAsset asset) throws SerializationException {
        ContentHandler handler = ContentManager.getHandler((String)asset.getFormat());
        StringBuilder stringBuilder = new StringBuilder();
        if (handler.isRuleAsset()) {
            BRMSPackageBuilder builder = new BRMSPackageBuilder();
            PackageItem packageItem = this.getRulesRepository().loadPackage(asset.getMetaData().getPackageName());
            builder.setDSLFiles(DSLLoader.loadDSLMappingFiles((PackageItem)packageItem));
            if (asset.getMetaData().isBinary()) {
                AssetItem item = this.getRulesRepository().loadAssetByUUID(asset.getUuid());
                handler.storeAssetContent(asset, item);
                ((IRuleAsset)handler).assembleDRL(builder, item, stringBuilder);
            } else {
                ((IRuleAsset)handler).assembleDRL(builder, asset, stringBuilder);
            }
        } else if (handler instanceof ICanRenderSource) {
            ICanRenderSource crs = (ICanRenderSource)handler;
            crs.assembleSource(asset.getContent(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    protected PageResponse<AssetPageRow> findAssetPage(AssetPageRequest request) {
        log.debug("Finding asset page of packageUuid (" + request.getPackageUuid() + ")");
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getAssetIterator(request);
        long totalRowsCount = iterator.getSize();
        List rowList = new AssetPageRowBuilder().withPageRequest((PageRequest)request).withContent(iterator).build();
        PageResponse response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!iterator.hasNext()).buildWithTotalRowCount(totalRowsCount);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Found asset page of packageUuid (" + request.getPackageUuid() + ") in " + methodDuration + " ms.");
        return response;
    }

    protected PageResponse<QueryPageRow> quickFindAsset(QueryPageRequest request) {
        String search = request.getSearchText().replace('*', '%');
        if (!search.startsWith("%")) {
            search = "%" + search;
        }
        if (!search.endsWith("%")) {
            search = search + "%";
        }
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getRulesRepository().findAssetsByName(search, request.isSearchArchived().booleanValue(), request.isCaseSensitive().booleanValue());
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List rowList = new QuickFindPageRowBuilder().withPageRequest((PageRequest)request).withContent((Iterator)iterator).build();
        PageResponse response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!iterator.hasNext()).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Queried repository (Quick Find) for (" + search + ") in " + methodDuration + " ms.");
        return response;
    }

    protected void lockAsset(String uuid) {
        AssetLockManager lockManager = AssetLockManager.instance();
        String userName = Contexts.isApplicationContextActive() ? Identity.instance().getCredentials().getUsername() : "anonymous";
        log.info("Locking asset uuid=" + uuid + " for user [" + userName + "]");
        lockManager.lockAsset(uuid, userName);
    }

    protected void unLockAsset(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        log.info("Unlocking asset [" + uuid + "]");
        alm.unLockAsset(uuid);
    }

    protected String getAssetLockerUserName(String uuid) {
        AssetLockManager alm = AssetLockManager.instance();
        String userName = alm.getAssetLockerUserName(uuid);
        log.info("Asset locked by [" + userName + "]");
        return userName;
    }

    protected RuleAsset loadAsset(AssetItem item) throws SerializationException {
        RuleAsset asset = new RuleAsset();
        asset.setUuid(item.getUUID());
        asset.setName(item.getName());
        asset.setDescription(item.getDescription());
        asset.setLastModified(item.getLastModified().getTime());
        asset.setLastContributor(item.getLastContributor());
        asset.setState(item.getState() != null ? item.getState().getName() : "");
        asset.setDateCreated(item.getCreatedDate().getTime());
        asset.setCheckinComment(item.getCheckinComment());
        asset.setVersionNumber(item.getVersionNumber());
        asset.setFormat(item.getFormat());
        asset.setMetaData(this.populateMetaData(item));
        ContentHandler handler = ContentManager.getHandler((String)asset.getFormat());
        handler.retrieveAssetContent(asset, item);
        return asset;
    }

    MetaData populateMetaData(AssetItem item) {
        MetaData meta = this.populateMetaData((VersionableItem)item);
        meta.setPackageName(item.getPackageName());
        meta.setPackageUUID(item.getPackage().getUUID());
        meta.setBinary(item.isBinary());
        List categories = item.getCategories();
        this.fillMetaCategories(meta, categories);
        meta.setDateEffective(this.calendarToDate(item.getDateEffective()));
        meta.setDateExpired(this.calendarToDate(item.getDateExpired()));
        return meta;
    }

    MetaData populateMetaData(VersionableItem item) {
        MetaData meta = new MetaData();
        MetaDataMapper.getInstance().copyToMetaData(meta, (Object)item);
        return meta;
    }

    private void fillMetaCategories(MetaData meta, List<CategoryItem> categories) {
        meta.setCategories(new String[categories.size()]);
        for (int i = 0; i < meta.getCategories().length; ++i) {
            CategoryItem cat = categories.get(i);
            meta.getCategories()[i] = cat.getFullPath();
        }
    }

    private Date calendarToDate(Calendar createdDate) {
        if (createdDate == null) {
            return null;
        }
        return createdDate.getTime();
    }

    protected void clearAllDiscussionsForAsset(String assetId) {
        RulesRepository repo = this.getRulesRepository();
        AssetItem asset = repo.loadAssetByUUID(assetId);
        asset.updateStringProperty("", "discussion");
        repo.save();
        this.push("discussion", assetId);
    }

    protected List<DiscussionRecord> addToDiscussionForAsset(String assetId, String comment) {
        RulesRepository repository = this.getRulesRepository();
        AssetItem asset = repository.loadAssetByUUID(assetId);
        Discussion dp = new Discussion();
        List discussion = dp.fromString(asset.getStringProperty("discussion"));
        discussion.add(new DiscussionRecord(repository.getSession().getUserID(), StringEscapeUtils.escapeXml((String)comment)));
        asset.updateStringProperty(dp.toString(discussion), "discussion", false);
        repository.save();
        this.push("discussion", assetId);
        MailboxService.getInstance().recordItemUpdated(asset);
        return discussion;
    }

    protected long getAssetCount(AssetPageRequest request) {
        log.debug("Counting assets in packageUuid (" + request.getPackageUuid() + ")");
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getAssetIterator(request);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Counted assets in packageUuid (" + request.getPackageUuid() + ") in " + methodDuration + " ms.");
        return iterator.getSize();
    }

    private AssetItemIterator getAssetIterator(AssetPageRequest request) {
        AssetItemIterator iterator;
        PackageItem packageItem = this.getRulesRepository().loadPackageByUUID(request.getPackageUuid());
        if (request.getFormatInList() != null) {
            if (request.getFormatIsRegistered() != null) {
                throw new IllegalArgumentException("Combining formatInList and formatIsRegistered is not yet supported.");
            }
            iterator = packageItem.listAssetsByFormat(request.getFormatInList());
        } else {
            iterator = request.getFormatIsRegistered() != null && request.getFormatIsRegistered().equals(Boolean.FALSE) ? packageItem.listAssetsNotOfFormat(this.registeredFormats) : packageItem.queryAssets("");
        }
        return iterator;
    }

    private void push(String messageType, String message) {
        Backchannel.getInstance().publish(new PushResponse(messageType, message));
    }

    private String getCurrentUserName() {
        return this.getRulesRepository().getSession().getUserID();
    }
}

