/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringEscapeUtils;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.InboxPageRequest;
import org.drools.guvnor.client.rpc.InboxPageRow;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.LogPageRow;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PermissionsPageRow;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.QueryMetadataPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.StatePageRequest;
import org.drools.guvnor.client.rpc.StatePageRow;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.AssetTemplateCreator;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.RepositoryPackageOperations;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.SuggestionCompletionEngineLoaderInitializer;
import org.drools.guvnor.server.builder.PageResponseBuilder;
import org.drools.guvnor.server.builder.pagerow.InboxPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.LogPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.PermissionPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.QueryFullTextPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.QueryMetadataPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.StatePageRowBuilder;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.ruleeditor.springcontext.SpringContextElementsManager;
import org.drools.guvnor.server.ruleeditor.workitem.WorkitemDefinitionElementsManager;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.RoleTypes;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.guvnor.server.util.DateUtil;
import org.drools.guvnor.server.util.HtmlCleaner;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.security.PermissionManager;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.mvel2.MVEL;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.client.rpc.RepositoryService")
@AutoCreate
public class ServiceImplementation
implements RepositoryService {
    @In
    private RulesRepository repository;
    private static final long serialVersionUID = 510L;
    private static final LoggingHelper log = LoggingHelper.getLogger(ServiceImplementation.class);
    private final ServiceSecurity serviceSecurity = new ServiceSecurity();
    private final RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
    private final RepositoryPackageOperations repositoryPackageOperations = new RepositoryPackageOperations();

    @Create
    public void create() {
        this.repositoryAssetOperations.setRulesRepository(this.getRulesRepository());
        this.repositoryPackageOperations.setRulesRepository(this.getRulesRepository());
    }

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
        this.create();
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listWorkspaces() {
        return this.getRulesRepository().listWorkspaces();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void createWorkspace(String workspace) {
        this.getRulesRepository().createWorkspace(workspace);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeWorkspace(String workspace) {
        this.getRulesRepository().removeWorkspace(workspace);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void updateWorkspace(String workspace, String[] selectedModules, String[] unselectedModules) {
        PackageItem module;
        for (String moduleName : selectedModules) {
            module = this.getRulesRepository().loadPackage(moduleName);
            module.addWorkspace(workspace);
            module.checkin("Add workspace");
        }
        for (String moduleName : unselectedModules) {
            module = this.getRulesRepository().loadPackage(moduleName);
            module.removeWorkspace(workspace);
            module.checkin("Remove workspace");
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String createNewRule(String ruleName, String description, String initialCategory, String initialPackage, String format) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(initialPackage);
        log.info("USER:" + this.getCurrentUserName() + " CREATING new asset name [" + ruleName + "] in package [" + initialPackage + "]");
        try {
            PackageItem pkg = this.getRulesRepository().loadPackage(initialPackage);
            AssetItem asset = pkg.addAsset(ruleName, description, initialCategory, format);
            new AssetTemplateCreator().applyPreBuiltTemplates(ruleName, format, asset);
            this.getRulesRepository().save();
            this.push("categoryChange", initialCategory);
            this.push("packageChange", pkg.getName());
            return asset.getUUID();
        }
        catch (RulesRepositoryException e) {
            if (e.getCause() instanceof ItemExistsException) {
                return "DUPLICATE";
            }
            log.error("An error occurred creating new asset" + ruleName + "] in package [" + initialPackage + "]: ", (Throwable)e);
            throw new SerializationException(e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String createNewImportedRule(String sharedAssetName, String initialPackage) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(initialPackage);
        log.info("USER:" + this.getRulesRepository().getSession().getUserID() + " CREATING shared asset imported from global area named [" + sharedAssetName + "] in package [" + initialPackage + "]");
        try {
            PackageItem packageItem = this.getRulesRepository().loadPackage(initialPackage);
            AssetItem asset = packageItem.addAssetImportedFromGlobalArea(sharedAssetName);
            this.getRulesRepository().save();
            return asset.getUUID();
        }
        catch (RulesRepositoryException e) {
            if (e.getCause() instanceof ItemExistsException) {
                return "DUPLICATE";
            }
            log.error("An error occurred creating shared asset" + sharedAssetName + "] in package [" + initialPackage + "]: ", (Throwable)e);
            throw new SerializationException(e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void deleteUncheckedRule(String uuid) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithAdminType();
        AssetItem asset = this.getRulesRepository().loadAssetByUUID(uuid);
        PackageItem packageItem = asset.getPackage();
        packageItem.updateBinaryUpToDate(false);
        asset.remove();
        this.getRulesRepository().save();
        this.push("packageChange", packageItem.getName());
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadRuleListForState(String stateName, int skip, int numRows, String tableConfig) throws SerializationException {
        AssetItemFilter filter = new AssetItemFilter();
        AssetItemPageResult result = this.getRulesRepository().findAssetsByState(stateName, false, skip, numRows, (RepositoryFilter)filter);
        return new TableDisplayHandler(tableConfig).loadRuleListTable(result);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableConfig loadTableConfig(String listName) {
        TableDisplayHandler handler = new TableDisplayHandler(listName);
        return handler.loadTableConfig();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult queryMetaData(MetaDataQuery[] qr, Date createdAfter, Date createdBefore, Date modifiedAfter, Date modifiedBefore, boolean seekArchived, int skip, int numRows) throws SerializationException {
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        1 q = new /* Unavailable Anonymous Inner Class!! */;
        RulesRepository.DateQuery[] dates = new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", DateUtil.isoDate((Date)createdAfter), DateUtil.isoDate((Date)createdBefore)), new RulesRepository.DateQuery("drools:lastModified", DateUtil.isoDate((Date)modifiedAfter), DateUtil.isoDate((Date)modifiedBefore))};
        AssetItemIterator it = this.getRulesRepository().query((Map)q, seekArchived, dates);
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        PackageFilter packageFilter = new PackageFilter();
        CategoryFilter categoryFilter = new CategoryFilter();
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!this.checkPackagePermissionHelper((RepositoryFilter)packageFilter, ai, RoleType.PACKAGE_READONLY.getName()) && !this.checkCategoryPermissionHelper((RepositoryFilter)categoryFilter, ai, RoleType.ANALYST_READ.getName())) continue;
            resultList.add(ai);
        }
        return new TableDisplayHandler("searchresults").loadRuleListTable(resultList, skip, numRows);
    }

    private boolean checkPackagePermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        return filter.accept((Object)this.getConfigDataHelper(item.getPackage().getUUID()), roleType);
    }

    private PackageConfigData getConfigDataHelper(String uuidStr) {
        PackageConfigData data = new PackageConfigData();
        data.setUuid(uuidStr);
        return data;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String createState(String name) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " CREATING state: [" + name + "]");
        try {
            name = HtmlCleaner.cleanHTML((String)name);
            String uuid = this.getRulesRepository().createState(name).getNode().getUUID();
            this.getRulesRepository().save();
            return uuid;
        }
        catch (RepositoryException e) {
            throw new SerializationException("Unable to create the status.");
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeState(String name) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " REMOVING state: [" + name + "]");
        try {
            this.getRulesRepository().loadState(name).remove();
            this.getRulesRepository().save();
        }
        catch (RulesRepositoryException e) {
            throw new DetailedSerializationException("Unable to remove status. It is probably still used (even by archived items).", e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void renameState(String oldName, String newName) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " RENAMING state: [" + oldName + "] to [" + newName + "]");
        this.getRulesRepository().renameState(oldName, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listStates() throws SerializationException {
        StateItem[] states = this.getRulesRepository().listStates();
        String[] result = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            result[i] = states[i].getName();
        }
        return result;
    }

    @WebRemote
    public void clearRulesRepository() {
        this.serviceSecurity.checkSecurityIsAdmin();
        RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(this.getRulesRepository().getSession());
        admin.clearRulesRepository();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SuggestionCompletionEngine loadSuggestionCompletionEngine(String packageName) throws SerializationException {
        SuggestionCompletionEngine suggestionCompletionEngine = null;
        try {
            PackageItem packageItem = this.getRulesRepository().loadPackage(packageName);
            suggestionCompletionEngine = new SuggestionCompletionEngineLoaderInitializer().loadFor(packageItem);
        }
        catch (RulesRepositoryException e) {
            log.error("An error occurred loadSuggestionCompletionEngine: " + e.getMessage());
            throw new SerializationException(e.getMessage());
        }
        return suggestionCompletionEngine;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] getCustomSelectors() throws SerializationException {
        return SelectorManager.getInstance().getCustomSelectors();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listRulesInGlobalArea() throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName("globalArea");
        return this.repositoryPackageOperations.listRulesInPackage("globalArea");
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listImagesInGlobalArea() throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName("globalArea");
        return this.repositoryPackageOperations.listImagesInPackage("globalArea");
    }

    @WebRemote
    public LogEntry[] showLog() {
        this.serviceSecurity.checkSecurityIsAdmin();
        return LoggingHelper.getMessages();
    }

    @WebRemote
    public PageResponse<LogPageRow> showLog(PageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        this.serviceSecurity.checkSecurityIsAdmin();
        long start = System.currentTimeMillis();
        LogEntry[] logEntries = LoggingHelper.getMessages();
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List rowList = new LogPageRowBuilder().withPageRequest(request).withContent(logEntries).build();
        PageResponse response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withTotalRowSizeExact().withLastPage(rowList.size() + request.getStartRowIndex() == logEntries.length).withTotalRowSize(logEntries.length).build();
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Retrieved Log Entries in " + methodDuration + " ms.");
        return response;
    }

    @WebRemote
    public void cleanLog() {
        this.serviceSecurity.checkSecurityIsAdmin();
        LoggingHelper.cleanLog();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] loadDropDownExpression(String[] valuePairs, String expression) {
        HashMap<String, String> context = new HashMap<String, String>();
        for (String valuePair : valuePairs) {
            if (valuePair == null) {
                return new String[0];
            }
            String[] pair = valuePair.split("=");
            context.put(pair[0], pair[1]);
        }
        Object result = MVEL.eval((String)(expression = (String)TemplateRuntime.eval((String)expression, context)));
        if (result instanceof String[]) {
            return (String[])result;
        }
        if (result instanceof List) {
            List l = (List)result;
            String[] xs = new String[l.size()];
            for (int i = 0; i < xs.length; ++i) {
                Object el = l.get(i);
                xs[i] = el.toString();
            }
            return xs;
        }
        return null;
    }

    @Restrict(value="#{identity.loggedIn}")
    public Map<String, List<String>> listUserPermissions() {
        this.serviceSecurity.checkSecurityIsAdmin();
        return new PermissionManager(this.getRulesRepository()).listUsers();
    }

    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<PermissionsPageRow> listUserPermissions(PageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        this.serviceSecurity.checkSecurityIsAdmin();
        long start = System.currentTimeMillis();
        Map permissions = new PermissionManager(this.getRulesRepository()).listUsers();
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List rowList = new PermissionPageRowBuilder().withPageRequest(request).withContent(permissions).build();
        PageResponse response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withTotalRowSize(permissions.size()).withTotalRowSizeExact().withPageRowList(rowList).withLastPage(rowList.size() + request.getStartRowIndex() == permissions.size()).build();
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Retrieved Log Entries in " + methodDuration + " ms.");
        return response;
    }

    @Restrict(value="#{identity.loggedIn}")
    public Map<String, List<String>> retrieveUserPermissions(String userName) {
        this.serviceSecurity.checkSecurityIsAdmin();
        PermissionManager pm = new PermissionManager(this.getRulesRepository());
        return pm.retrieveUserPermissions(userName);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void updateUserPermissions(String userName, Map<String, List<String>> perms) {
        this.serviceSecurity.checkSecurityIsAdmin();
        PermissionManager pm = new PermissionManager(this.getRulesRepository());
        log.info("Updating user permissions for userName [" + userName + "] to [" + perms + "]");
        pm.updateUserPermissions(userName, perms);
        this.getRulesRepository().save();
    }

    @Deprecated
    @Restrict(value="#{identity.loggedIn}")
    public String[] listAvailablePermissionTypes() {
        this.serviceSecurity.checkSecurityIsAdmin();
        return RoleTypes.listAvailableTypes();
    }

    @Restrict(value="#{identity.loggedIn}")
    public List<String> listAvailablePermissionRoleTypes() {
        this.serviceSecurity.checkSecurityIsAdmin();
        RoleType[] roleTypes = RoleType.values();
        ArrayList<String> values = new ArrayList<String>();
        for (RoleType roleType : roleTypes) {
            values.add(roleType.getName());
        }
        return values;
    }

    @Restrict(value="#{identity.loggedIn}")
    public void deleteUser(String userName) {
        log.info("Removing user permissions for user name [" + userName + "]");
        PermissionManager pm = new PermissionManager(this.getRulesRepository());
        pm.removeUserPermissions(userName);
        this.getRulesRepository().save();
    }

    @Restrict(value="#{identity.loggedIn}")
    public void createUser(String userName) {
        log.info("Creating user permissions, user name [" + userName + "]");
        PermissionManager pm = new PermissionManager(this.getRulesRepository());
        pm.createUser(userName);
        this.getRulesRepository().save();
    }

    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadInbox(String inboxName) throws DetailedSerializationException {
        try {
            UserInbox ib = new UserInbox(this.getRulesRepository());
            if (inboxName.equals("recentViewed")) {
                return UserInbox.toTable((List)ib.loadRecentOpened(), (boolean)false);
            }
            if (inboxName.equals("recentEdited")) {
                return UserInbox.toTable((List)ib.loadRecentEdited(), (boolean)false);
            }
            return UserInbox.toTable((List)ib.loadIncoming(), (boolean)true);
        }
        catch (Exception e) {
            log.error("Unable to load Inbox: " + e.getMessage());
            throw new DetailedSerializationException("Unable to load Inbox", e.getMessage());
        }
    }

    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<InboxPageRow> loadInbox(InboxPageRequest request) throws DetailedSerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        String inboxName = request.getInboxName();
        PageResponse response = new PageResponse();
        long start = System.currentTimeMillis();
        try {
            List entries = new UserInbox(this.getRulesRepository()).loadEntries(inboxName);
            log.debug("Search time: " + (System.currentTimeMillis() - start));
            Iterator iterator = entries.iterator();
            List rowList = new InboxPageRowBuilder().withPageRequest(request).withContent(iterator).build();
            response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withTotalRowSize(entries.size()).withTotalRowSizeExact().withPageRowList(rowList).withLastPage(!iterator.hasNext()).build();
            long methodDuration = System.currentTimeMillis() - start;
            log.debug("Queried inbox ('" + inboxName + "') in " + methodDuration + " ms.");
        }
        catch (Exception e) {
            log.error("Unable to load Inbox: " + e.getMessage());
            throw new DetailedSerializationException("Unable to load Inbox", e.getMessage());
        }
        return response;
    }

    public String processTemplate(String name, Map<String, Object> data) {
        try {
            Configuration configuration = new Configuration();
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            configuration.setTemplateUpdateDelay(0);
            Template template = new Template(name, (Reader)new InputStreamReader(ServiceImplementation.class.getResourceAsStream("/repoconfig/" + name + ".xml")), configuration);
            StringWriter stringwriter = new StringWriter();
            template.process(data, (Writer)stringwriter);
            return StringEscapeUtils.escapeXml((String)stringwriter.toString());
        }
        catch (Exception e) {
            return "";
        }
    }

    public Map<String, String> loadSpringContextElementData() throws DetailedSerializationException {
        try {
            return SpringContextElementsManager.getInstance().getElements();
        }
        catch (IOException ex) {
            log.error("Error loading Spring Context Elements", (Throwable)ex);
            throw new DetailedSerializationException("Error loading Spring Context Elements", "View server logs for more information");
        }
    }

    public Map<String, String> loadWorkitemDefinitionElementData() throws DetailedSerializationException {
        try {
            return WorkitemDefinitionElementsManager.getInstance().getElements();
        }
        catch (IOException ex) {
            log.error("Error loading Workitem Definition Elements", (Throwable)ex);
            throw new DetailedSerializationException("Error loading Workitem Definition Elements", "View server logs for more information");
        }
    }

    public Boolean isHostedMode() {
        return Contexts.isApplicationContextActive() ? Boolean.FALSE : Boolean.TRUE;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<QueryPageRow> queryFullText(QueryPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getRulesRepository().queryFullText(request.getSearchText(), request.isSearchArchived().booleanValue());
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List rowList = new QueryFullTextPageRowBuilder().withPageRequest(request).withContent((Iterator)iterator).build();
        boolean bHasMoreRows = iterator.hasNext();
        PageResponse response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!bHasMoreRows).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Queried repository (Full Text) for (" + request.getSearchText() + ") in " + methodDuration + " ms.");
        return response;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<QueryPageRow> queryMetaData(QueryMetadataPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        Map queryMap = this.createQueryMap(request.getMetadata());
        RulesRepository.DateQuery[] dates = this.createDateQueryForRepository(request);
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.getRulesRepository().query(queryMap, request.isSearchArchived(), dates);
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List rowList = new QueryMetadataPageRowBuilder().withPageRequest(request).withContent((Iterator)iterator).build();
        boolean bHasMoreRows = iterator.hasNext();
        PageResponse response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!bHasMoreRows).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Queried repository (Metadata) in " + methodDuration + " ms.");
        return response;
    }

    private Map<String, String[]> createQueryMap(List<MetaDataQuery> metaDataQuerys) {
        HashMap<String, String[]> queryMap = new HashMap<String, String[]>();
        for (MetaDataQuery metaDataQuery : metaDataQuerys) {
            String vals = metaDataQuery.valueList == null ? "" : metaDataQuery.valueList.trim();
            if (vals.length() <= 0) continue;
            queryMap.put(metaDataQuery.attribute, vals.split(",\\s?"));
        }
        return queryMap;
    }

    private RulesRepository.DateQuery[] createDateQueryForRepository(QueryMetadataPageRequest request) {
        RulesRepository.DateQuery[] dates = new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", DateUtil.isoDate((Date)request.getCreatedAfter()), DateUtil.isoDate((Date)request.getCreatedBefore())), new RulesRepository.DateQuery("drools:lastModified", DateUtil.isoDate((Date)request.getLastModifiedAfter()), DateUtil.isoDate((Date)request.getLastModifiedBefore()))};
        return dates;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<StatePageRow> loadRuleListForState(StatePageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        long start = System.currentTimeMillis();
        int numRowsToReturn = request.getPageSize() == null ? -1 : request.getPageSize();
        AssetItemPageResult result = this.getRulesRepository().findAssetsByState(request.getStateName(), false, request.getStartRowIndex(), numRowsToReturn, (RepositoryFilter)new AssetItemFilter());
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        boolean bHasMoreRows = result.hasNext;
        List rowList = new StatePageRowBuilder().withPageRequest((PageRequest)request).withContent(result.assets.iterator()).build();
        PageResponse response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!bHasMoreRows).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Searched for Assest with State (" + request.getStateName() + ") in " + methodDuration + " ms.");
        return response;
    }

    private boolean checkCategoryPermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        List tempCateList = item.getCategories();
        for (CategoryItem categoryItem : tempCateList) {
            if (!filter.accept((Object)categoryItem.getName(), roleType)) continue;
            return true;
        }
        return false;
    }

    private void push(String messageType, String message) {
        Backchannel.getInstance().publish(new PushResponse(messageType, message));
    }

    private String getCurrentUserName() {
        return this.getRulesRepository().getSession().getUserID();
    }

    public List<PushResponse> subscribe() {
        return Backchannel.getInstance().subscribe();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public boolean doesAssetExistInPackage(String assetName, String packageName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(packageName);
        try {
            PackageItem pkg = this.getRulesRepository().loadPackage(packageName);
            return pkg.containsAsset(assetName);
        }
        catch (RulesRepositoryException e) {
            log.error("An error occurred checking if asset [" + assetName + "] exists in package [" + packageName + "]: ", (Throwable)e);
            throw new SerializationException(e.getMessage());
        }
    }
}

