/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.configurations;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.core.util.DateUtils;
import org.drools.repository.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ApplicationPreferencesLoader {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPreferencesLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> load() {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = ApplicationPreferencesLoader.class.getResourceAsStream("/preferences.properties");
            properties.load(in);
            Map map = ApplicationPreferencesLoader.readPreferences((Properties)properties);
            return map;
        }
        catch (IOException e) {
            log.info("Couldn't find preferences.properties - using defaults");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            return hashMap;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static Map<String, String> readPreferences(Properties properties) {
        Map preferences = ApplicationPreferencesLoader.getDefaultPreferences();
        ApplicationPreferencesLoader.addPreferencesFromProperties((Properties)properties, (Map)preferences);
        return preferences;
    }

    private static void addPreferencesFromProperties(Properties properties, Map<String, String> preferences) {
        for (Object key : properties.keySet()) {
            String feature = (String)key;
            preferences.put(feature, properties.getProperty(feature));
        }
    }

    private static Map<String, String> getDefaultPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", DateUtils.getDateFormatMask());
        preferences.put("drools.defaultlanguage", System.getProperty("drools.defaultlanguage"));
        preferences.put("drools.defaultcountry", System.getProperty("drools.defaultcountry"));
        return preferences;
    }
}

