/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.RepositoryPackageService;
import org.drools.guvnor.server.files.ActionsAPI;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class ActionsAPI {
    public void post(RepositoryPackageService service, RulesRepository repository, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String packageName = request.getParameter(Parameters.PackageName.toString());
            String[] pathstr = this.split(request.getPathTranslated());
            if (pathstr[0].equals("compile")) {
                if (repository.containsPackage(packageName)) {
                    PackageIterator iter = repository.listPackages();
                    while (iter.hasNext()) {
                        PackageItem p = iter.next();
                        if (!p.getName().equals(packageName)) continue;
                        String uuid = p.getUUID();
                        service.buildPackage(uuid, true);
                        break;
                    }
                }
            } else if (pathstr[0].equals("snapshot")) {
                if (repository.containsPackage(packageName)) {
                    String snapshotName = request.getParameter(Parameters.SnapshotName.toString());
                    repository.createPackageSnapshot(packageName, snapshotName);
                } else {
                    throw new RulesRepositoryException("Unknown action request: " + request.getContextPath());
                }
            }
            response.setContentType("text/html");
            response.setStatus(200);
            response.getWriter().write("OK");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    String[] split(String path) throws UnsupportedEncodingException {
        if (path.indexOf("action") > -1) {
            path = path.split("action")[1];
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] bits = path.split("/");
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = URLDecoder.decode(bits[i], "UTF-8");
        }
        return bits;
    }
}

