/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Link;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.guvnor.server.jaxrs.jaxb.AssetMetadata;
import org.drools.guvnor.server.jaxrs.jaxb.Package;
import org.drools.guvnor.server.jaxrs.jaxb.PackageMetadata;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class Translator {
    public static final String NS = "";
    public static final QName METADATA = new QName("", "metadata");
    public static final QName VALUE = new QName("", "value");
    public static final QName ARCHIVED = new QName("", "archived");
    public static final QName UUID = new QName("", "uuid");
    public static final QName STATE = new QName("", "state");
    public static final QName FORMAT = new QName("", "format");
    public static final QName CATEGORIES = new QName("", "categories");

    public static Asset toAsset(AssetItem a, UriInfo uriInfo) {
        AssetMetadata metadata = new AssetMetadata();
        metadata.setUuid(a.getUUID());
        metadata.setTitle(a.getTitle());
        metadata.setLastModified(a.getLastModified().getTime());
        metadata.setCreated(a.getCreatedDate().getTime());
        metadata.setCreatedBy(a.getCreator());
        metadata.setDisabled(a.getDisabled());
        metadata.setFormat(a.getFormat());
        metadata.setNote("<![CDATA[ " + a.getCheckinComment() + " ]]>");
        List categories = a.getCategories();
        String[] cats = new String[categories.size()];
        int counter = 0;
        for (CategoryItem c : categories) {
            cats[counter++] = c.getName();
        }
        Asset ret = new Asset();
        ret.setMetadata(metadata);
        ret.setType(a.getType());
        ret.setCheckInComment(a.getCheckinComment());
        ret.setDescription(a.getDescription());
        UriBuilder builder = uriInfo.getBaseUriBuilder();
        ret.setRefLink(builder.path("/packages/" + a.getPackage().getName() + "/assets/" + a.getName()).build(new Object[0]));
        builder = uriInfo.getBaseUriBuilder();
        ret.setBinaryLink(builder.path("/packages/" + a.getPackage().getName() + "/assets/" + a.getName() + "/binary").build(new Object[0]));
        builder = uriInfo.getBaseUriBuilder();
        ret.setSourceLink(builder.path("/packages/" + a.getPackage().getName() + "/assets/" + a.getName() + "/source").build(new Object[0]));
        ret.setVersion(a.getVersionNumber());
        return ret;
    }

    public static Package toPackage(PackageItem p, UriInfo uriInfo) {
        PackageMetadata metadata = new PackageMetadata();
        metadata.setUuid(p.getUUID());
        metadata.setCreated(p.getCreatedDate().getTime());
        metadata.setLastModified(p.getLastModified().getTime());
        metadata.setLastContributor(p.getLastContributor());
        metadata.setState(p.getState() != null ? p.getState().getName() : "");
        Package ret = new Package();
        ret.setMetadata(metadata);
        ret.setVersion(p.getVersionNumber());
        ret.setTitle(p.getTitle());
        ret.setCheckInComment(p.getCheckinComment());
        ret.setDescription(p.getDescription());
        UriBuilder builder = uriInfo.getBaseUriBuilder();
        ret.setBinaryLink(builder.path("/packages/" + p.getName() + "/binary").build(new Object[0]));
        builder = uriInfo.getBaseUriBuilder();
        ret.setSourceLink(builder.path("/packages/" + p.getName() + "/source").build(new Object[0]));
        ret.setVersion(p.getVersionNumber());
        Iterator iter = p.getAssets();
        HashSet<URI> assets = new HashSet<URI>();
        while (iter.hasNext()) {
            AssetItem a = (AssetItem)iter.next();
            Asset asset = Translator.toAsset((AssetItem)a, (UriInfo)uriInfo);
            assets.add(asset.getRefLink());
        }
        ret.setAssets(assets);
        return ret;
    }

    public static Entry toPackageEntryAbdera(PackageItem p, UriInfo uriInfo) {
        UriBuilder base = p.isHistoricalVersion() ? uriInfo.getBaseUriBuilder().path("packages").path(p.getName()).path("versions").path(Long.toString(p.getVersionNumber())) : uriInfo.getBaseUriBuilder().path("packages").path(p.getName());
        Factory factory = Abdera.getNewFactory();
        Entry e = factory.getAbdera().newEntry();
        e.setTitle(p.getTitle());
        e.setSummary(p.getDescription());
        e.setPublished(new Date(p.getLastModified().getTimeInMillis()));
        e.setBaseUri(base.clone().build(new Object[0]).toString());
        e.addAuthor(p.getLastContributor());
        e.setId(base.clone().build(new Object[0]).toString());
        Iterator i = p.getAssets();
        while (i.hasNext()) {
            AssetItem item = (AssetItem)i.next();
            Link l = factory.newLink();
            l.setHref(base.clone().path("assets").path(item.getName()).build(new Object[0]).toString());
            l.setTitle(item.getTitle());
            l.setRel("asset");
            e.addLink(l);
        }
        ExtensibleElement extension = (ExtensibleElement)e.addExtension(METADATA);
        ExtensibleElement childExtension = (ExtensibleElement)extension.addExtension(ARCHIVED);
        childExtension.addSimpleExtension(VALUE, p.isArchived() ? "true" : "false");
        childExtension = (ExtensibleElement)extension.addExtension(UUID);
        childExtension.addSimpleExtension(VALUE, p.getUUID());
        childExtension = (ExtensibleElement)extension.addExtension(STATE);
        childExtension.addSimpleExtension(VALUE, p.getState() == null ? "" : p.getState().getName());
        Content content = factory.newContent();
        content.setSrc(base.clone().path("binary").build(new Object[0]).toString());
        content.setMimeType("application/octet-stream");
        content.setContentType(Content.Type.MEDIA);
        e.setContentElement(content);
        return e;
    }

    public static Entry toAssetEntryAbdera(AssetItem a, UriInfo uriInfo) {
        UriBuilder base = a.isHistoricalVersion() ? uriInfo.getBaseUriBuilder().path("packages").path(a.getPackageName()).path("assets").path(a.getName()).path("versions").path(Long.toString(a.getVersionNumber())) : uriInfo.getBaseUriBuilder().path("packages").path(a.getPackageName()).path("assets").path(a.getName());
        Factory factory = Abdera.getNewFactory();
        Entry e = factory.getAbdera().newEntry();
        e.setTitle(a.getTitle());
        e.setSummary(a.getDescription());
        e.setPublished(new Date(a.getLastModified().getTimeInMillis()));
        e.setBaseUri(base.clone().build(new Object[0]).toString());
        e.addAuthor(a.getLastContributor());
        e.setId(base.clone().build(new Object[0]).toString());
        ExtensibleElement extension = (ExtensibleElement)e.addExtension(METADATA);
        ExtensibleElement childExtension = (ExtensibleElement)extension.addExtension(ARCHIVED);
        childExtension.addSimpleExtension(VALUE, a.isArchived() ? "true" : "false");
        childExtension = (ExtensibleElement)extension.addExtension(UUID);
        childExtension.addSimpleExtension(VALUE, a.getUUID());
        childExtension = (ExtensibleElement)extension.addExtension(STATE);
        childExtension.addSimpleExtension(VALUE, a.getState() == null ? "" : a.getState().getName());
        childExtension = (ExtensibleElement)extension.addExtension(FORMAT);
        childExtension.addSimpleExtension(VALUE, a.getFormat());
        List categories = a.getCategories();
        childExtension = (ExtensibleElement)extension.addExtension(CATEGORIES);
        for (CategoryItem c : categories) {
            childExtension.addSimpleExtension(VALUE, c.getName());
        }
        Content content = factory.newContent();
        content.setSrc(base.clone().path("binary").build(new Object[0]).toString());
        content.setMimeType("application/octet-stream");
        content.setContentType(Content.Type.MEDIA);
        e.setContentElement(content);
        return e;
    }
}

