/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleType;
import org.drools.repository.RulesRepository;
import org.drools.repository.security.PermissionManager;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.server.security.RoleBasedPermissionStore")
@AutoCreate
public class RoleBasedPermissionStore {
    @In
    public RulesRepository repository;

    public List<RoleBasedPermission> getRoleBasedPermissionsByUserName(String userName) {
        PermissionManager permissionManager = new PermissionManager(this.repository);
        ArrayList<RoleBasedPermission> permissions = new ArrayList<RoleBasedPermission>();
        Map perms = permissionManager.retrieveUserPermissions(userName);
        for (Map.Entry permEntry : perms.entrySet()) {
            this.resolvePermissionsAndAdd(userName, permissions, permEntry);
        }
        return permissions;
    }

    private void resolvePermissionsAndAdd(String userName, List<RoleBasedPermission> permissions, Map.Entry<String, List<String>> permEntry) {
        String roleType = permEntry.getKey();
        if (RoleType.ADMIN.getName().equals(roleType)) {
            permissions.add(new RoleBasedPermission(userName, RoleType.ADMIN.getName(), null, null));
        }
        List<String> permissionsPerRole = permEntry.getValue();
        for (String permissionPerRole : permissionsPerRole) {
            if (permissionPerRole.startsWith("package=")) {
                String packageName = permissionPerRole.substring("package=".length());
                permissions.add(new RoleBasedPermission(userName, roleType, packageName, null));
                continue;
            }
            if (!permissionPerRole.startsWith("category=")) continue;
            String categoryPath = permissionPerRole.substring("category=".length());
            permissions.add(new RoleBasedPermission(userName, roleType, null, categoryPath));
        }
    }

    public void addRoleBasedPermissionForTesting(String userName, RoleBasedPermission rbp) {
        PermissionManager permissionManager = new PermissionManager(this.repository);
        Map perms = permissionManager.retrieveUserPermissions(userName);
        Object permissionsPerRole = perms.get(rbp.getRole());
        if (permissionsPerRole != null) {
            if (rbp.getPackageName() != null) {
                ((List)permissionsPerRole).add("package=" + rbp.getPackageName());
            } else if (rbp.getCategoryPath() != null) {
                ((List)permissionsPerRole).add("category=" + rbp.getPackageName());
            }
        } else {
            ArrayList<String> perm = new ArrayList<String>();
            if (rbp.getPackageName() != null) {
                perm.add("package=" + rbp.getPackageName());
            } else if (rbp.getCategoryPath() != null) {
                perm.add("category=" + rbp.getCategoryPath());
            }
            perms.put(rbp.getRole(), perm);
        }
        permissionManager.updateUserPermissions(userName, perms);
    }
}

