/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security.rules;

import java.util.List;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.PathHelper;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.rules.PermissionRule;
import org.drools.guvnor.server.util.LoggingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryPathTypePermissionRule
implements PermissionRule {
    private static final LoggingHelper log = LoggingHelper.getLogger(CategoryPathTypePermissionRule.class);

    public boolean hasPermission(Object requestedObject, String requestedPermission, List<RoleBasedPermission> permissions) {
        String requestedPermType;
        String requestedPath = ((CategoryPathType)requestedObject).getCategoryPath();
        String string = requestedPermType = requestedPermission == null ? RoleType.ANALYST.getName() : requestedPermission;
        if (requestedPermType.equals("navigate")) {
            for (RoleBasedPermission roleBasedPermission : permissions) {
                if (roleBasedPermission.getCategoryPath() == null) continue;
                if (this.isCategoryPathMatched(requestedPath, roleBasedPermission)) {
                    return true;
                }
                if (PathHelper.isSubPath((String)requestedPath, (String)roleBasedPermission.getCategoryPath())) {
                    log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: Yes");
                    return true;
                }
                if (!PathHelper.isSubPath((String)roleBasedPermission.getCategoryPath(), (String)requestedPath)) continue;
                log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: Yes");
                return true;
            }
            log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: No");
            return false;
        }
        for (RoleBasedPermission roleBasedPermission : permissions) {
            if (!this.isRoleAnalyst(roleBasedPermission) || !this.isPermissionToCurrentDirectory(requestedPermType, roleBasedPermission) || !this.isPermittedCategoryPath(requestedPath, roleBasedPermission.getCategoryPath())) continue;
            log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: Yes");
            return true;
        }
        log.debug("Requested permission: " + requestedPermType + ", Requested object: " + requestedPath + " , Permission granted: No");
        return false;
    }

    private boolean isPermissionToCurrentDirectory(String requestedPermType, RoleBasedPermission roleBasedPermission) {
        return requestedPermType.equals(roleBasedPermission.getRole()) || requestedPermType.equals(RoleType.ANALYST_READ.getName()) && roleBasedPermission.getRole().equals(RoleType.ANALYST.getName());
    }

    private boolean isRoleAnalyst(RoleBasedPermission roleBasedPermission) {
        return roleBasedPermission.getRole().equals(RoleType.ANALYST.getName()) || roleBasedPermission.getRole().equals(RoleType.ANALYST_READ.getName());
    }

    private boolean isCategoryPathMatched(String requestedPath, RoleBasedPermission roleBasedPermission) {
        return roleBasedPermission.getCategoryPath().equals(requestedPath);
    }

    private boolean isPermittedCategoryPath(String requestedPath, String allowedPath) {
        if (requestedPath == null && allowedPath == null) {
            return true;
        }
        if (requestedPath == null || allowedPath == null) {
            return false;
        }
        return requestedPath.equals(allowedPath) || PathHelper.isSubPath((String)allowedPath, (String)requestedPath);
    }
}

