/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.drools.guvnor.server.util.AssetEditorConfigElement;
import org.drools.guvnor.server.util.AssetEditorConfiguration;
import org.drools.guvnor.server.util.AssetEditorConfigurationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEditorConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(AssetEditorConfigurationParser.class);
    private static final String ASSETEDITOR_CONFIG = "/asseteditors.xml";
    static final String ASSET_EDITOR = "asseteditor";
    static final String TITLE = "title";
    static final String CLASS = "class";
    static final String ICON = "icon";
    static final String FORMAT = "format";
    private List<AssetEditorConfiguration> assetEditors;

    public List<AssetEditorConfiguration> getAssetEditors() {
        if (this.assetEditors == null) {
            this.assetEditors = this.readConfig();
        }
        return this.assetEditors;
    }

    private List<AssetEditorConfiguration> readConfig() {
        ArrayList<AssetEditorConfiguration> assetEditors = new ArrayList<AssetEditorConfiguration>();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            InputStream in = this.getClass().getResourceAsStream(ASSETEDITOR_CONFIG);
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            AssetEditorConfiguration configuration = null;
            while (eventReader.hasNext()) {
                AssetEditorConfigElement element;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    element = AssetEditorConfigElement.forName((String)event.asStartElement().getName().getLocalPart());
                    switch (1.$SwitchMap$org$drools$guvnor$server$util$AssetEditorConfigElement[element.ordinal()]) {
                        case 1: {
                            configuration = new AssetEditorConfiguration();
                            break;
                        }
                        case 2: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setFormat(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setFormat("");
                            break;
                        }
                        case 3: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setTitle(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setTitle("");
                            break;
                        }
                        case 4: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setIcon(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setIcon("");
                            break;
                        }
                        case 5: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setEditorClass(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setEditorClass("");
                        }
                    }
                }
                if (!event.isEndElement() || (element = AssetEditorConfigElement.forName((String)event.asEndElement().getName().getLocalPart())) != AssetEditorConfigElement.ASSET_EDITOR) continue;
                assetEditors.add(configuration);
            }
        }
        catch (XMLStreamException e) {
            log.error("Failed to parse Asset editor configuration file", (Throwable)e);
            e.printStackTrace();
        }
        return assetEditors;
    }

    public static void main(String[] agrs) {
        AssetEditorConfigurationParser a = new AssetEditorConfigurationParser();
        a.readConfig();
    }
}

