/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.verification;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.drools.builder.ResourceType;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.server.factconstraints.factory.ConstraintsFactory;
import org.drools.io.ResourceFactory;
import org.drools.verifier.DefaultVerifierConfiguration;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class VerifierConfigurationFactory {
    public static VerifierConfiguration getDefaultConfigurationWithWorkingSetConstraints(RuleAsset[] workingSets) throws SerializationException {
        return VerifierConfigurationFactory.addWorkingSetConstraints((Collection)VerifierConfigurationFactory.getConstraintRulesFromWorkingSets((RuleAsset[])workingSets), (VerifierConfiguration)new DefaultVerifierConfiguration());
    }

    public static VerifierConfiguration getPlainWorkingSetVerifierConfiguration(RuleAsset[] workingSets) throws SerializationException {
        return VerifierConfigurationFactory.addWorkingSetConstraints((Collection)VerifierConfigurationFactory.getConstraintRulesFromWorkingSets((RuleAsset[])workingSets), (VerifierConfiguration)new VerifierConfigurationImpl());
    }

    private static VerifierConfiguration addWorkingSetConstraints(Collection<String> additionalVerifierRules, VerifierConfiguration configuration) {
        if (additionalVerifierRules != null) {
            for (String rule : additionalVerifierRules) {
                configuration.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
            }
        }
        return configuration;
    }

    private static List<String> getConstraintRulesFromWorkingSets(RuleAsset[] workingSets) {
        LinkedList<String> constraintRules = new LinkedList<String>();
        if (workingSets != null) {
            for (RuleAsset workingSet : workingSets) {
                WorkingSetConfigData wsConfig = (WorkingSetConfigData)workingSet.content;
                if (wsConfig.constraints == null) continue;
                for (ConstraintConfiguration config : wsConfig.constraints) {
                    constraintRules.add(ConstraintsFactory.getInstance().getVerifierRule(config));
                }
            }
        }
        return constraintRules;
    }
}

