/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.Image;

public class ImageButton
extends Image {
    private ImageResource img;
    private ImageResource disabledImg;
    private ClickHandler clickHandler;
    private HandlerRegistration handlerRegistration;

    @UiConstructor
    public ImageButton(ImageResource img) {
        super(img);
        this.img = img;
        this.disabledImg = img;
        this.setStyleName("image-Button");
    }

    public ImageButton(ImageResource img, ImageResource disabledImg, String tooltip) {
        super(img);
        this.img = img;
        this.disabledImg = disabledImg;
        this.setStyleName("image-Button");
    }

    public ImageButton(ImageResource img, ImageResource disabledImg) {
        super(img);
        this.img = img;
        this.disabledImg = disabledImg;
        this.setStyleName("image-Button");
    }

    public ImageButton(ImageResource img, String tooltip) {
        super(img);
        this.img = img;
        this.disabledImg = img;
        this.setStyleName("image-Button");
        this.setTitle(tooltip);
    }

    public ImageButton(ImageResource img, String tooltip, ClickHandler clickHandler) {
        this(img, tooltip);
        this.clickHandler = clickHandler;
        this.assertClickHandler();
    }

    public ImageButton(ImageResource img, ImageResource disabledImg, String tooltip, ClickHandler clickHandler) {
        this(img, disabledImg, tooltip);
        this.clickHandler = clickHandler;
        this.assertClickHandler();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setResource(this.img);
            this.assertClickHandler();
        } else {
            super.setResource(this.disabledImg);
            this.removeClickHandler();
        }
    }

    private void assertClickHandler() {
        if (this.clickHandler != null && this.handlerRegistration == null) {
            this.handlerRegistration = this.addClickHandler(this.clickHandler);
        }
    }

    private void removeClickHandler() {
        if (this.handlerRegistration != null) {
            this.handlerRegistration.removeHandler();
            this.handlerRegistration = null;
        }
    }
}

