/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.wizards;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.Popup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.widgets.wizards.WizardActivityView;
import org.drools.guvnor.client.widgets.wizards.WizardActivityViewImpl;
import org.drools.guvnor.client.widgets.wizards.WizardPage;
import org.drools.guvnor.client.widgets.wizards.WizardPageTitle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardActivityViewImpl
extends Popup
implements WizardActivityView {
    @UiField
    protected VerticalPanel sideBar;
    @UiField
    protected SimplePanel sideBarContainer;
    @UiField
    ScrollPanel bodyContainer;
    @UiField
    protected SimplePanel body;
    @UiField
    protected Button btnNext;
    @UiField
    protected Button btnPrevious;
    @UiField
    protected Button btnFinish;
    private Widget content;
    private List<WizardPageTitle> pageTitleWidgets = new ArrayList();
    private int pageNumber;
    private int pageNumberTotal;
    private WizardActivityView.Presenter presenter;
    private EventBus eventBus;
    private static WizardActivityViewImplBinder uiBinder = (WizardActivityViewImplBinder)GWT.create(WizardActivityViewImplBinder.class);
    private static Constants constants = (Constants)GWT.create(Constants.class);

    public WizardActivityViewImpl(EventBus eventBus) {
        this.eventBus = eventBus;
        this.content = (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public Widget getContent() {
        return this.content;
    }

    public void setPresenter(WizardActivityView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setPageTitles(List<WizardPage> pages) {
        this.pageNumberTotal = pages.size() - 1;
        for (WizardPage page : pages) {
            WizardPageTitle wpt = new WizardPageTitle(this.eventBus, page);
            this.pageTitleWidgets.add(wpt);
            this.sideBar.add((Widget)wpt);
        }
    }

    @UiHandler(value={"btnCancel"})
    public void btnCancelClick(ClickEvent event) {
        this.hide();
    }

    @UiHandler(value={"btnFinish"})
    public void btnFinishClick(ClickEvent event) {
        this.presenter.complete();
    }

    @UiHandler(value={"btnNext"})
    public void btnNextClick(ClickEvent event) {
        if (this.pageNumber == this.pageNumberTotal) {
            return;
        }
        this.selectPage(this.pageNumber + 1);
        this.btnNext.setFocus(false);
    }

    @UiHandler(value={"btnPrevious"})
    public void btnPreviousClick(ClickEvent event) {
        if (this.pageNumber == 0) {
            return;
        }
        this.selectPage(this.pageNumber - 1);
        this.btnPrevious.setFocus(false);
    }

    public void selectPage(int pageNumber) {
        if (pageNumber < 0 || pageNumber > this.pageTitleWidgets.size() - 1) {
            return;
        }
        this.pageNumber = pageNumber;
        for (int i = 0; i < this.pageTitleWidgets.size(); ++i) {
            WizardPageTitle wpt = (WizardPageTitle)this.pageTitleWidgets.get(i);
            wpt.setPageSelected(i == pageNumber);
        }
        this.btnNext.setEnabled(pageNumber < this.pageNumberTotal);
        this.btnPrevious.setEnabled(pageNumber > 0);
        this.presenter.pageSelected(pageNumber);
    }

    public void setBodyWidget(Widget w) {
        this.body.setWidget(w);
        this.center();
    }

    public void setPreferredHeight(int height) {
        this.bodyContainer.setHeight(height + "px");
        this.sideBarContainer.setHeight(height + "px");
    }

    public void setPreferredWidth(int width) {
        this.bodyContainer.setWidth(width + "px");
    }

    public void setPageCompletionState(int pageIndex, boolean isComplete) {
        WizardPageTitle wpt = (WizardPageTitle)this.pageTitleWidgets.get(pageIndex);
        wpt.setComplete(isComplete);
    }

    public void setCompletionStatus(boolean isComplete) {
        this.btnFinish.setEnabled(isComplete);
    }

    public void showSavingIndicator() {
        LoadingPopup.showMessage((String)constants.SavingPleaseWait());
    }

    public void hideSavingIndicator() {
        LoadingPopup.close();
    }

    public void showDuplicateAssetNameError() {
        Window.alert((String)constants.AssetNameAlreadyExistsPickAnother());
    }

    public void showUnspecifiedCheckinError() {
        ErrorPopup.showMessage((String)constants.FailedToCheckInTheItemPleaseContactYourSystemAdministrator());
    }

    public void showCheckinError(String message) {
        ErrorPopup.showMessage((String)message);
    }
}

