/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyErrorLogger {
    private final List<ContentAssemblyError> errors = new ArrayList();

    public void logError(ContentAssemblyError err) {
        this.errors.add(err);
    }

    public void addError(PackageItem packageItem, String errorReport) {
        this.errors.add(new ContentAssemblyError(errorReport, packageItem.getFormat(), packageItem.getName(), packageItem.getUUID(), true, false));
    }

    public void addError(AssetItem assetItem, String errorReport) {
        this.errors.add(new ContentAssemblyError(errorReport, assetItem.getFormat(), assetItem.getName(), assetItem.getUUID(), false, true));
    }

    public void addError(String message, String format, String name, String uuid, boolean isPackageItem, boolean isAssetItem) {
        this.errors.add(new ContentAssemblyError(message, format, name, uuid, isPackageItem, isAssetItem));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<ContentAssemblyError> getErrors() {
        return this.errors;
    }
}

